/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.apache.spark.deploy.Docker$;
import org.apache.spark.deploy.DockerId;
import org.apache.spark.deploy.TestMasterInfo;
import org.apache.spark.deploy.TestWorkerInfo;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple3;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger$;

public final class SparkDocker$ {
    public static final SparkDocker$ MODULE$ = new SparkDocker$();

    public TestMasterInfo startMaster(String mountDir) {
        String x$1 = "spark-test-master";
        String x$2 = mountDir;
        String x$3 = Docker$.MODULE$.makeRunCmd$default$2();
        ProcessBuilder cmd = Docker$.MODULE$.makeRunCmd("spark-test-master", x$3, x$2);
        Tuple3<String, DockerId, File> tuple3 = this.startNode(cmd);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String ip = (String)tuple3._1();
        DockerId id = (DockerId)tuple3._2();
        File outFile = (File)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)ip, (Object)id, (Object)outFile);
        String ip2 = (String)tuple32._1();
        DockerId id2 = (DockerId)tuple32._2();
        File outFile2 = (File)tuple32._3();
        return new TestMasterInfo(ip2, id2, outFile2);
    }

    public TestWorkerInfo startWorker(String mountDir, String masters) {
        ProcessBuilder cmd = Docker$.MODULE$.makeRunCmd("spark-test-worker", masters, mountDir);
        Tuple3<String, DockerId, File> tuple3 = this.startNode(cmd);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String ip = (String)tuple3._1();
        DockerId id = (DockerId)tuple3._2();
        File outFile = (File)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)ip, (Object)id, (Object)outFile);
        String ip2 = (String)tuple32._1();
        DockerId id2 = (DockerId)tuple32._2();
        File outFile2 = (File)tuple32._3();
        return new TestWorkerInfo(ip2, id2, outFile2);
    }

    private Tuple3<String, DockerId, File> startNode(ProcessBuilder dockerCmd) {
        Promise ipPromise = Promise$.MODULE$.apply();
        File outFile = File.createTempFile("fault-tolerance-test", "", Utils$.MODULE$.createTempDir());
        FileWriter outStream = new FileWriter(outFile);
        dockerCmd.run(ProcessLogger$.MODULE$.apply((Function1 & Serializable)line -> {
            SparkDocker$.findIpAndLog$1(line, ipPromise, outStream);
            return BoxedUnit.UNIT;
        }));
        String ip = (String)ThreadUtils$.MODULE$.awaitResult(ipPromise.future(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
        DockerId dockerId = Docker$.MODULE$.getLastProcessId();
        return new Tuple3((Object)ip, (Object)dockerId, (Object)outFile);
    }

    private static final void findIpAndLog$1(String line, Promise ipPromise$1, FileWriter outStream$1) {
        if (line.startsWith("CONTAINER_IP=")) {
            String ip = line.split("=")[1];
            v0 = ipPromise$1.success((Object)ip);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        outStream$1.write(line + "\n");
        outStream$1.flush();
    }

    private SparkDocker$() {
    }
}

