/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.collect;

import java.util.Comparator;
import java.util.SortedSet;
import org.sparkproject.connect.guava.annotations.GwtCompatible;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.collect.Ordering;
import org.sparkproject.connect.guava.collect.SortedIterable;

@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            comparator2 = SortedIterables.comparator((SortedSet)elements);
        } else if (elements instanceof SortedIterable) {
            comparator2 = ((SortedIterable)elements).comparator();
        } else {
            return false;
        }
        return comparator.equals(comparator2);
    }

    public static <E> Comparator<? super E> comparator(SortedSet<E> sortedSet) {
        Comparator<E> result = sortedSet.comparator();
        if (result == null) {
            result = Ordering.natural();
        }
        return result;
    }
}

