/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.flow.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.volcano.api.model.flow.v1alpha1.Flow;
import io.fabric8.volcano.api.model.flow.v1alpha1.FlowBuilder;
import io.fabric8.volcano.api.model.flow.v1alpha1.FlowFluent;
import io.fabric8.volcano.api.model.flow.v1alpha1.JobFlowSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class JobFlowSpecFluent<A extends JobFlowSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<FlowBuilder> flows = new ArrayList();
    private String jobRetainPolicy;

    public JobFlowSpecFluent() {
    }

    public JobFlowSpecFluent(JobFlowSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToFlows(Collection<Flow> items) {
        if (this.flows == null) {
            this.flows = new ArrayList();
        }
        for (Flow item : items) {
            FlowBuilder builder = new FlowBuilder(item);
            this._visitables.get((Object)"flows").add(builder);
            this.flows.add(builder);
        }
        return (A)((Object)this);
    }

    public FlowsNested<A> addNewFlow() {
        return new FlowsNested(-1, null);
    }

    public FlowsNested<A> addNewFlowLike(Flow item) {
        return new FlowsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToFlows(Flow ... items) {
        if (this.flows == null) {
            this.flows = new ArrayList();
        }
        for (Flow item : items) {
            FlowBuilder builder = new FlowBuilder(item);
            this._visitables.get((Object)"flows").add(builder);
            this.flows.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToFlows(int index, Flow item) {
        if (this.flows == null) {
            this.flows = new ArrayList();
        }
        FlowBuilder builder = new FlowBuilder(item);
        if (index < 0 || index >= this.flows.size()) {
            this._visitables.get((Object)"flows").add(builder);
            this.flows.add(builder);
        } else {
            this._visitables.get((Object)"flows").add(builder);
            this.flows.add(index, builder);
        }
        return (A)((Object)this);
    }

    public Flow buildFirstFlow() {
        return this.flows.get(0).build();
    }

    public Flow buildFlow(int index) {
        return this.flows.get(index).build();
    }

    public List<Flow> buildFlows() {
        return this.flows != null ? JobFlowSpecFluent.build(this.flows) : null;
    }

    public Flow buildLastFlow() {
        return this.flows.get(this.flows.size() - 1).build();
    }

    public Flow buildMatchingFlow(Predicate<FlowBuilder> predicate) {
        for (FlowBuilder item : this.flows) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(JobFlowSpec instance) {
        JobFlowSpec jobFlowSpec = instance = instance != null ? instance : new JobFlowSpec();
        if (instance != null) {
            this.withFlows(instance.getFlows());
            this.withJobRetainPolicy(instance.getJobRetainPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FlowsNested<A> editFirstFlow() {
        if (this.flows.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "flows"));
        }
        return this.setNewFlowLike(0, this.buildFlow(0));
    }

    public FlowsNested<A> editFlow(int index) {
        if (this.flows.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "flows"));
        }
        return this.setNewFlowLike(index, this.buildFlow(index));
    }

    public FlowsNested<A> editLastFlow() {
        int index = this.flows.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "flows"));
        }
        return this.setNewFlowLike(index, this.buildFlow(index));
    }

    public FlowsNested<A> editMatchingFlow(Predicate<FlowBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.flows.size(); ++i) {
            if (!predicate.test(this.flows.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "flows"));
        }
        return this.setNewFlowLike(index, this.buildFlow(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobFlowSpecFluent that = (JobFlowSpecFluent)((Object)o);
        if (!Objects.equals(this.flows, that.flows)) {
            return false;
        }
        if (!Objects.equals(this.jobRetainPolicy, that.jobRetainPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getJobRetainPolicy() {
        return this.jobRetainPolicy;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFlows() {
        return this.flows != null && !this.flows.isEmpty();
    }

    public boolean hasJobRetainPolicy() {
        return this.jobRetainPolicy != null;
    }

    public boolean hasMatchingFlow(Predicate<FlowBuilder> predicate) {
        for (FlowBuilder item : this.flows) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.flows, this.jobRetainPolicy, this.additionalProperties);
    }

    public A removeAllFromFlows(Collection<Flow> items) {
        if (this.flows == null) {
            return (A)((Object)this);
        }
        for (Flow item : items) {
            FlowBuilder builder = new FlowBuilder(item);
            this._visitables.get((Object)"flows").remove((Object)builder);
            this.flows.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromFlows(Flow ... items) {
        if (this.flows == null) {
            return (A)((Object)this);
        }
        for (Flow item : items) {
            FlowBuilder builder = new FlowBuilder(item);
            this._visitables.get((Object)"flows").remove((Object)builder);
            this.flows.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFlows(Predicate<FlowBuilder> predicate) {
        if (this.flows == null) {
            return (A)((Object)this);
        }
        Iterator<FlowBuilder> each = this.flows.iterator();
        List visitables = this._visitables.get((Object)"flows");
        while (each.hasNext()) {
            FlowBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public FlowsNested<A> setNewFlowLike(int index, Flow item) {
        return new FlowsNested(index, item);
    }

    public A setToFlows(int index, Flow item) {
        if (this.flows == null) {
            this.flows = new ArrayList();
        }
        FlowBuilder builder = new FlowBuilder(item);
        if (index < 0 || index >= this.flows.size()) {
            this._visitables.get((Object)"flows").add(builder);
            this.flows.add(builder);
        } else {
            this._visitables.get((Object)"flows").add(builder);
            this.flows.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.flows != null && !this.flows.isEmpty()) {
            sb.append("flows:");
            sb.append(this.flows);
            sb.append(",");
        }
        if (this.jobRetainPolicy != null) {
            sb.append("jobRetainPolicy:");
            sb.append(this.jobRetainPolicy);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFlows(List<Flow> flows) {
        if (this.flows != null) {
            this._visitables.get((Object)"flows").clear();
        }
        if (flows != null) {
            this.flows = new ArrayList();
            for (Flow item : flows) {
                this.addToFlows(item);
            }
        } else {
            this.flows = null;
        }
        return (A)((Object)this);
    }

    public A withFlows(Flow ... flows) {
        if (this.flows != null) {
            this.flows.clear();
            this._visitables.remove((Object)"flows");
        }
        if (flows != null) {
            for (Flow item : flows) {
                this.addToFlows(item);
            }
        }
        return (A)((Object)this);
    }

    public A withJobRetainPolicy(String jobRetainPolicy) {
        this.jobRetainPolicy = jobRetainPolicy;
        return (A)((Object)this);
    }

    public class FlowsNested<N>
    extends FlowFluent<FlowsNested<N>>
    implements Nested<N> {
        FlowBuilder builder;
        int index;

        FlowsNested(int index, Flow item) {
            this.index = index;
            this.builder = new FlowBuilder(this, item);
        }

        public N and() {
            return (N)JobFlowSpecFluent.this.setToFlows(this.index, this.builder.build());
        }

        public N endFlow() {
            return this.and();
        }
    }
}

