/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.spark.SparkException$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001\u0002\u0013&\u0001IB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000f\")A\n\u0001C\u0001\u001b\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0004Z\u0001\t\u0007I\u0011B)\t\ri\u0003\u0001\u0015!\u0003S\u0011!Y\u0006\u0001#b\u0001\n\u0013a\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007k\u0002\u0001\u000b\u0011\u00022\t\u000fY\u0004!\u0019!C\u0005o\"9\u00111\u0002\u0001!\u0002\u0013A\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\t9\u0002\u0001Q\u0001\n\u0005E\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003?\u0003A\u0011BAQ\u0011\u001d\t)\u000b\u0001C\u0005\u0003OCq!a+\u0001\t\u0013\ti\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0006bBAb\u0001\u0011%\u0011Q\u0019\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!a5\u0001\t\u0013\t)\u000eC\u0004\u0002f\u0002!I!a:\t\u0013\u0005E\bA1A\u0005\n\u0005M\b\u0002CA~\u0001\u0001\u0006I!!>\u0003\u001d\r\u001bf+\u00138gKJ\u001c6\r[3nC*\u0011aeJ\u0001\u0004GN4(B\u0001\u0015*\u0003!\u0019\u0017\r^1msN$(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011c\u0001\u00014sA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\u0004\"A\u000f\"\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 2\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Bk\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tU'A\u0004paRLwN\\:\u0016\u0003\u001d\u0003\"\u0001S%\u000e\u0003\u0015J!AS\u0013\u0003\u0015\r\u001bfk\u00149uS>t7/\u0001\u0005paRLwN\\:!\u0003\u0019a\u0014N\\5u}Q\u0011aj\u0014\t\u0003\u0011\u0002AQ!R\u0002A\u0002\u001d\u000bq\u0002^5nKN$\u0018-\u001c9QCJ\u001cXM]\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011QkJ\u0001\u0005kRLG.\u0003\u0002X)\n\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003A!\u0018.\\3ti\u0006l\u0007\u000fU1sg\u0016\u0014\b%A\u000buS6,7\u000f^1na:#&LR8s[\u0006$H/\u001a:\u0002-QLW.Z:uC6\u0004h\n\u0016.G_Jl\u0017\r\u001e;fe\u0002\nQ\u0002Z1uK\u001a{'/\\1ui\u0016\u0014X#A/\u0011\u0005Ms\u0016BA0U\u00055!\u0015\r^3G_Jl\u0017\r\u001e;fe\u0006iA-Z2j[\u0006d\u0007+\u0019:tKJ,\u0012A\u0019\t\u0005i\r,W.\u0003\u0002ek\tIa)\u001e8di&|g.\r\t\u0003M*t!a\u001a5\u0011\u0005q*\u0014BA56\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%,\u0004C\u00018t\u001b\u0005y'B\u00019r\u0003\u0011i\u0017\r\u001e5\u000b\u0003I\fAA[1wC&\u0011Ao\u001c\u0002\u000b\u0005&<G)Z2j[\u0006d\u0017A\u00043fG&l\u0017\r\u001c)beN,'\u000fI\u0001,\u0019\u0016s\u0015*\u0012(U?R\u001bvLR(S\u001b\u0006#F+\u0012*`'V\u0003\u0006k\u0014*U\u000b\u0012{F)\u0011+F?\u001a{%+T!U'V\t\u0001\u0010\u0005\u0003z}\u0006\u0005Q\"\u0001>\u000b\u0005md\u0018!C5n[V$\u0018M\u00197f\u0015\tiX'\u0001\u0006d_2dWm\u0019;j_:L!a >\u0003\u0007M+G\u000f\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9!]\u0001\u0005Y\u0006tw-C\u0002l\u0003\u000b\tA\u0006T#O\u0013\u0016sEk\u0018+T?\u001a{%+T!U)\u0016\u0013vlU+Q!>\u0013F+\u0012#`\t\u0006#Vi\u0018$P%6\u000bEk\u0015\u0011\u0002\u0019%\u001cH)\u001a4bk2$h\n\u0016.\u0016\u0005\u0005E\u0001c\u0001\u001b\u0002\u0014%\u0019\u0011QC\u001b\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011n\u001d#fM\u0006,H\u000e\u001e(U5\u0002\na!Z9vC2\u001cH\u0003BA\t\u0003;Aq!a\b\u0010\u0001\u0004\t\t#A\u0002pE*\u00042\u0001NA\u0012\u0013\r\t)#\u000e\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005-\u0002c\u0001\u001b\u0002.%\u0019\u0011qF\u001b\u0003\u0007%sG/A\u0003j]\u001a,'\u000f\u0006\u0004\u00026\u0005\u0005\u0013q\u000b\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H\u0015\u0002\u000bQL\b/Z:\n\t\u0005}\u0012\u0011\b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\"#\u0001\u0007\u0011QI\u0001\ti>\\WM\u001c*E\tB1\u0011qIA'\u0003#j!!!\u0013\u000b\u0007\u0005-3&A\u0002sI\u0012LA!a\u0014\u0002J\t\u0019!\u000b\u0012#\u0011\tQ\n\u0019&Z\u0005\u0004\u0003+*$!B!se\u0006L\bbBA-#\u0001\u0007\u0011\u0011K\u0001\u0007Q\u0016\fG-\u001a:\u0002\u001dQ|7\u000b\u001e:vGR4\u0015.\u001a7egR1\u0011qLA4\u0003g\u0002R\u0001NA*\u0003C\u0002B!a\u000e\u0002d%!\u0011QMA\u001d\u0005-\u0019FO];di\u001aKW\r\u001c3\t\u000f\u0005%$\u00031\u0001\u0002l\u0005Qa-[3mIRK\b/Z:\u0011\u000bQ\n\u0019&!\u001c\u0011\t\u0005]\u0012qN\u0005\u0005\u0003c\nID\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\tIF\u0005a\u0001\u0003#\nA\"\u001b8gKJ\u0014vn\u001e+za\u0016$b!a\u001b\u0002z\u0005u\u0004bBA>'\u0001\u0007\u00111N\u0001\te><8k\u001c$be\"9\u0011qP\nA\u0002\u0005E\u0013\u0001\u00028fqR\fQ\"\\3sO\u0016\u0014vn\u001e+za\u0016\u001cHCBA6\u0003\u000b\u000bI\tC\u0004\u0002\bR\u0001\r!a\u001b\u0002\u000b\u0019L'o\u001d;\t\u000f\u0005-E\u00031\u0001\u0002l\u000511/Z2p]\u0012\f!\"\u001b8gKJ4\u0015.\u001a7e)\u0019\ti'!%\u0002\u0016\"9\u00111S\u000bA\u0002\u00055\u0014!\u0003;za\u0016\u001cvNR1s\u0011\u0019\t9*\u0006a\u0001K\u0006)a-[3mI\u0006Q\u0011n]%oM>\u0013h*\u00198\u0015\t\u0005E\u0011Q\u0014\u0005\u0007\u0003/3\u0002\u0019A3\u0002\u001fQ\u0014\u0018\u0010U1sg\u0016Le\u000e^3hKJ$B!!\u001c\u0002$\"1\u0011qS\fA\u0002\u0015\fA\u0002\u001e:z!\u0006\u00148/\u001a'p]\u001e$B!!\u001c\u0002*\"1\u0011q\u0013\rA\u0002\u0015\fq\u0002\u001e:z!\u0006\u00148/\u001a#fG&l\u0017\r\u001c\u000b\u0005\u0003[\ny\u000b\u0003\u0004\u0002\u0018f\u0001\r!Z\u0001\u000fiJL\b+\u0019:tK\u0012{WO\u00197f)\u0011\ti'!.\t\r\u0005]%\u00041\u0001f\u00031!(/\u001f)beN,G)\u0019;f)\u0011\ti'a/\t\r\u0005]5\u00041\u0001f\u0003Q!(/\u001f)beN,G+[7fgR\fW\u000e\u001d(U5R!\u0011QNAa\u0011\u0019\t9\n\ba\u0001K\u0006\tBO]=QCJ\u001cX\rV5nKN$\u0018-\u001c9\u0015\t\u00055\u0014q\u0019\u0005\u0007\u0003/k\u0002\u0019A3\u0002\u001fQ\u0014\u0018\u0010U1sg\u0016\u0014un\u001c7fC:$B!!\u001c\u0002N\"1\u0011q\u0013\u0010A\u0002\u0015\f!b\u001d;sS:<G+\u001f9f)\t\ti'\u0001\bd_6\u0004\u0018\r^5cY\u0016$\u0016\u0010]3\u0015\r\u0005]\u0017Q\\Aq!\u0015!\u0014\u0011\\A7\u0013\r\tY.\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005}\u0007\u00051\u0001\u0002n\u0005\u0011A/\r\u0005\b\u0003G\u0004\u0003\u0019AA7\u0003\t!('A\fdC:\u0004\u0016M]:f\t\u0006$X-Q:US6,7\u000f^1naR1\u0011\u0011CAu\u0003[Da!a;\"\u0001\u0004)\u0017A\u00033bi\u00164uN]7bi\"9\u0011q^\u0011A\u0002\u00055\u0014A\u0002;t)f\u0004X-\u0001\rgS:$7i\\7qCRL'\r\\3UsB,gi\u001c:D'Z+\"!!>\u0011\u0013Q\n90!\u001c\u0002n\u0005]\u0017bAA}k\tIa)\u001e8di&|gNM\u0001\u001aM&tGmQ8na\u0006$\u0018N\u00197f)f\u0004XMR8s\u0007N3\u0006\u0005")
public class CSVInferSchema
implements Serializable {
    private DateFormatter dateFormatter;
    private final CSVOptions options;
    private final TimestampFormatter timestampParser;
    private final TimestampFormatter timestampNTZFormatter;
    private final Function1<String, BigDecimal> decimalParser;
    private final Set<String> LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS;
    private final boolean isDefaultNTZ;
    private final Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV;
    private volatile boolean bitmap$0;

    public CSVOptions options() {
        return this.options;
    }

    private TimestampFormatter timestampParser() {
        return this.timestampParser;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter$lzycompute() {
        CSVInferSchema cSVInferSchema = this;
        synchronized (cSVInferSchema) {
            if (!this.bitmap$0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.options().dateFormatInRead(), this.options().locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
                this.bitmap$0 = true;
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        if (!this.bitmap$0) {
            return this.dateFormatter$lzycompute();
        }
        return this.dateFormatter;
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private Set<String> LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS() {
        return this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS;
    }

    private boolean isDefaultNTZ() {
        return this.isDefaultNTZ;
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof CSVInferSchema) {
            CSVInferSchema cSVInferSchema = (CSVInferSchema)object;
            CSVOptions cSVOptions = this.options();
            CSVOptions cSVOptions2 = cSVInferSchema.options();
            return !(cSVOptions != null ? !((Object)cSVOptions).equals(cSVOptions2) : cSVOptions2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.options().hashCode();
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header) {
        StructField[] structFieldArray;
        if (this.options().inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2 & Serializable)(rowSoFar, next) -> this.inferRowType((DataType[])rowSoFar, (String[])next), (Function2 & Serializable)(first, second) -> this.mergeRowTypes((DataType[])first, (DataType[])second), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = this.toStructFields(rootTypes, header);
        } else {
            structFieldArray = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])header), (Function1 & Serializable)fieldName -> new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), ClassTag$.MODULE$.apply(StructField.class));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public StructField[] toStructFields(DataType[] fieldTypes, String[] header) {
        return (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])header), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fieldTypes))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String thisHeader = (String)tuple2._1();
                DataType rootType = (DataType)tuple2._2();
                DataType dataType = rootType;
                StringType$ dType = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
                return new StructField(thisHeader, (DataType)dType, true, StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(StructField.class));
    }

    public DataType[] inferRowType(DataType[] rowSoFar, String[] next) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next[i]);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipAll$extension(Predef$.MODULE$.refArrayOps((Object[])first), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$)), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DataType a = (DataType)tuple2._1();
                DataType b = (DataType)tuple2._2();
                return (DataType)this.compatibleType(a, b).getOrElse((Function0 & Serializable)() -> NullType$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(DataType.class));
    }

    public DataType inferField(DataType typeSoFar, String field) {
        DataType dataType;
        block25: {
            block24: {
                if (field == null || field.isEmpty()) break block24;
                String string = field;
                String string2 = this.options().nullValue();
                if (string != null ? !string.equals(string2) : string2 != null) break block25;
            }
            return typeSoFar;
        }
        DataType dataType2 = typeSoFar;
        if (NullType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(field);
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseInteger(field);
        } else if (LongType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseLong(field);
        } else if (dataType2 instanceof DecimalType) {
            dataType = this.tryParseDecimal(field);
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseDouble(field);
        } else if (DateType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseDate(field);
        } else if (TimestampNTZType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseTimestampNTZ(field);
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseTimestamp(field);
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            dataType = this.tryParseBoolean(field);
        } else if (StringType$.MODULE$.equals(dataType2)) {
            dataType = StringType$.MODULE$;
        } else {
            if (dataType2 != null) {
                DataType dataType3 = dataType2;
                throw SparkException$.MODULE$.internalError("Unexpected data type " + dataType3);
            }
            throw new MatchError((Object)dataType2);
        }
        DataType typeElemInfer = dataType;
        return (DataType)this.compatibleType(typeSoFar, typeElemInfer).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field) {
        String string = field;
        String string2 = this.options().nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = this.options().negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = this.options().positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(field))).isDefined()) {
            return IntegerType$.MODULE$;
        }
        return this.tryParseLong(field);
    }

    private DataType tryParseLong(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(field))).isDefined()) {
            return LongType$.MODULE$;
        }
        return this.tryParseDecimal(field);
    }

    private DataType tryParseDecimal(String field) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
            BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field);
            if (bigDecimal.scale() <= 0) {
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }
            return this.tryParseDouble(field);
        });
        return (DataType)decimalTry.getOrElse((Function0 & Serializable)() -> this.tryParseDouble(field));
    }

    private DataType tryParseDouble(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcD.sp & Serializable)() -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(field))).isDefined() || this.isInfOrNan(field)) {
            return DoubleType$.MODULE$;
        }
        if (this.options().preferDate()) {
            return this.tryParseDate(field);
        }
        return this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseDate(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcI.sp & Serializable)() -> this.dateFormatter().parse(field)).isDefined()) {
            return DateType$.MODULE$;
        }
        return this.tryParseTimestampNTZ(field);
    }

    private DataType tryParseTimestampNTZ(String field) {
        if (this.isDefaultNTZ() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined()) {
            return TimestampNTZType$.MODULE$;
        }
        return this.tryParseTimestamp(field);
    }

    private DataType tryParseTimestamp(String field) {
        if (this.timestampParser().parseOptional(field).isDefined()) {
            return TimestampType$.MODULE$;
        }
        return this.tryParseBoolean(field);
    }

    private DataType tryParseBoolean(String field) {
        if (Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(field))).isDefined()) {
            return BooleanType$.MODULE$;
        }
        return this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private Option<DataType> compatibleType(DataType t1, DataType t2) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        var7_3 = new Tuple2((Object)t1, (Object)t2);
                        if (var7_3 == null) break block5;
                        var8_4 = (DataType)var7_3._1();
                        var9_5 = (DataType)var7_3._2();
                        if (!DateType$.MODULE$.equals(var8_4) || !TimestampType$.MODULE$.equals(var9_5)) break block5;
                        v0 = true;
                        break block6;
                    }
                    if (var7_3 == null) break block7;
                    var10_6 = (DataType)var7_3._1();
                    var11_7 = (DataType)var7_3._2();
                    if (!DateType$.MODULE$.equals(var10_6) || !TimestampNTZType$.MODULE$.equals(var11_7)) break block7;
                    v0 = true;
                    break block6;
                }
                if (var7_3 == null) break block8;
                var12_8 = (DataType)var7_3._1();
                var13_9 = (DataType)var7_3._2();
                if (!TimestampNTZType$.MODULE$.equals(var12_8) || !DateType$.MODULE$.equals(var13_9)) break block8;
                v0 = true;
                break block6;
            }
            if (var7_3 == null) ** GOTO lbl-1000
            var14_10 = (DataType)var7_3._1();
            var15_11 = (DataType)var7_3._2();
            if (TimestampType$.MODULE$.equals(var14_10) && DateType$.MODULE$.equals(var15_11)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            dateFormat = (String)this.options().dateFormatInRead().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$1(), ()Ljava/lang/String;)());
            var17_13 = t1;
            if (DateType$.MODULE$.equals(var17_13) && this.canParseDateAsTimestamp(dateFormat, t2)) {
                return new Some((Object)t2);
            }
            if ((TimestampType$.MODULE$.equals(var17_13) != false ? true : TimestampNTZType$.MODULE$.equals(var17_13) != false) && this.canParseDateAsTimestamp(dateFormat, t1)) {
                return new Some((Object)t1);
            }
            return new Some((Object)StringType$.MODULE$);
        }
        return ((Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)t1, (Object)t2)).orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compatibleType$2(org.apache.spark.sql.catalyst.csv.CSVInferSchema org.apache.spark.sql.types.DataType org.apache.spark.sql.types.DataType ), ()Lscala/Option;)((CSVInferSchema)this, (DataType)t1, (DataType)t2));
    }

    private boolean canParseDateAsTimestamp(String dateFormat, DataType tsType) {
        if (tsType instanceof TimestampType && this.options().timestampFormatInRead().isEmpty() || tsType instanceof TimestampNTZType && this.options().timestampNTZFormatInRead().isEmpty()) {
            return this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS().contains((Object)dateFormat);
        }
        return false;
    }

    private Function2<DataType, DataType, Option<DataType>> findCompatibleTypeForCSV() {
        return this.findCompatibleTypeForCSV;
    }

    public static final /* synthetic */ String $anonfun$compatibleType$1() {
        return DateFormatter$.MODULE$.defaultPattern();
    }

    public static final /* synthetic */ Option $anonfun$compatibleType$2(CSVInferSchema $this, DataType t1$1, DataType t2$1) {
        return (Option)$this.findCompatibleTypeForCSV().apply((Object)t1$1, (Object)t2$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$findCompatibleTypeForCSV$1(CSVInferSchema $this, DataType x0$1, DataType x1$1) {
        block21: {
            block20: {
                block19: {
                    block18: {
                        var6_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (var6_3 != null && StringType$.MODULE$.equals(var7_4 = (DataType)var6_3._1())) {
                            return new Some((Object)StringType$.MODULE$);
                        }
                        if (var6_3 != null && StringType$.MODULE$.equals(var8_5 = (DataType)var6_3._2())) {
                            return new Some((Object)StringType$.MODULE$);
                        }
                        if (var6_3 != null) {
                            t1 = (DataType)var6_3._1();
                            t2 = (DataType)var6_3._2();
                            if (t1 instanceof IntegralType) {
                                var11_8 = (IntegralType)t1;
                                if (t2 instanceof DecimalType) {
                                    var12_9 = (DecimalType)t2;
                                    return $this.compatibleType((DataType)DecimalType$.MODULE$.forType((DataType)var11_8), (DataType)var12_9);
                                }
                            }
                        }
                        if (var6_3 != null) {
                            t1 = (DataType)var6_3._1();
                            t2 = (DataType)var6_3._2();
                            if (t1 instanceof DecimalType) {
                                var15_12 = (DecimalType)t1;
                                if (t2 instanceof IntegralType) {
                                    var16_13 = (IntegralType)t2;
                                    return $this.compatibleType((DataType)var15_12, (DataType)DecimalType$.MODULE$.forType((DataType)var16_13));
                                }
                            }
                        }
                        if (var6_3 == null || !DoubleType$.MODULE$.equals(var17_14 = (DataType)var6_3._1()) || !(var6_3._2() instanceof DecimalType)) break block18;
                        v0 = true;
                        break block19;
                    }
                    if (var6_3 == null) ** GOTO lbl-1000
                    var18_15 = (DataType)var6_3._2();
                    if (var6_3._1() instanceof DecimalType && DoubleType$.MODULE$.equals(var18_15)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                }
                if (v0) {
                    return new Some((Object)DoubleType$.MODULE$);
                }
                if (var6_3 != null) {
                    t1 = (DataType)var6_3._1();
                    t2 = (DataType)var6_3._2();
                    if (t1 instanceof DecimalType) {
                        var21_18 = (DecimalType)t1;
                        if (t2 instanceof DecimalType) {
                            var22_19 = (DecimalType)t2;
                            scale = package$.MODULE$.max(var21_18.scale(), var22_19.scale());
                            range = package$.MODULE$.max(var21_18.precision() - var21_18.scale(), var22_19.precision() - var22_19.scale());
                            if (range + scale > 38) {
                                return new Some((Object)DoubleType$.MODULE$);
                            }
                            return new Some((Object)new DecimalType(range + scale, scale));
                        }
                    }
                }
                if (var6_3 == null) break block20;
                var25_22 = (DataType)var6_3._1();
                var26_23 = (DataType)var6_3._2();
                if (!TimestampNTZType$.MODULE$.equals(var25_22) || !TimestampType$.MODULE$.equals(var26_23)) break block20;
                v1 = true;
                break block21;
            }
            if (var6_3 == null) ** GOTO lbl-1000
            var27_24 = (DataType)var6_3._1();
            var28_25 = (DataType)var6_3._2();
            if (TimestampType$.MODULE$.equals(var27_24) && TimestampNTZType$.MODULE$.equals(var28_25)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v1) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        return None$.MODULE$;
    }

    public CSVInferSchema(CSVOptions options) {
        this.options = options;
        this.timestampParser = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        Locale locale = options.locale();
        Locale locale2 = Locale.US;
        this.decimalParser = !(locale != null ? !((Object)locale).equals(locale2) : locale2 != null) ? s -> new BigDecimal((String)s) : ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.LENIENT_TS_FORMATTER_SUPPORTED_DATE_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy-M-dd", "yyyy-MM-d", "yyyy-MM", "yyyy-M", "yyyy"}));
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        this.isDefaultNTZ = !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        this.findCompatibleTypeForCSV = (arg_0, arg_1) -> CSVInferSchema.$anonfun$findCompatibleTypeForCSV$1(this, arg_0, arg_1);
    }
}

