/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeDTInterval$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([days[, hours[, mins[, secs]]]]) - Make DayTimeIntervalType duration from days, hours, mins and secs.", arguments="\n    Arguments:\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 12, 30, 01.001001);\n       1 12:30:01.001001000\n      > SELECT _FUNC_(2);\n       2 00:00:00.000000000\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n  ", since="3.2.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001B\u0017/\u0001nB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t;\u0002\u0011\t\u0012)A\u00055\"Aa\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005`\u0001\tE\t\u0015!\u0003[\u0011!\u0001\u0007A!f\u0001\n\u0003I\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u0002.\t\u0011\t\u0004!Q3A\u0005\u0002eC\u0001b\u0019\u0001\u0003\u0012\u0003\u0006IA\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006I\u0002!\t\u0001\u001d\u0005\u0006I\u0002!\t\u0001\u001e\u0005\u0006I\u0002!\ta\u001e\u0005\u0006I\u0002!\t!\u001f\u0005\u0006u\u0002!\t%\u0017\u0005\u0006w\u0002!\t%\u0017\u0005\u0006y\u0002!\t%\u0017\u0005\u0006{\u0002!\t%\u0017\u0005\u0006}\u0002!\te \u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005%\u0004\u0001\"\u0015\u0002l!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004\"CAD\u0001\u0005\u0005I\u0011AAE\u0011%\t\u0019\nAI\u0001\n\u0003\t)\nC\u0005\u0002,\u0002\t\n\u0011\"\u0001\u0002\u0016\"I\u0011Q\u0016\u0001\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003_\u0003\u0011\u0013!C\u0001\u0003+C\u0011\"!-\u0001\u0003\u0003%\t%a-\t\u0013\u0005\r\u0007!!A\u0005\u0002\u0005\u0015\u0007\"CAg\u0001\u0005\u0005I\u0011AAh\u0011%\t)\u000eAA\u0001\n\u0003\n9\u000eC\u0005\u0002f\u0002\t\t\u0011\"\u0001\u0002h\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0013Q\u001e\u0005\n\u0003c\u0004\u0011\u0011!C!\u0003g<\u0011B!\b/\u0003\u0003E\tAa\b\u0007\u00115r\u0013\u0011!E\u0001\u0005CAa\u0001Z\u0014\u0005\u0002\te\u0002\"\u0003B\u001eO\u0005\u0005IQ\tB\u001f\u0011%\u0011ydJA\u0001\n\u0003\u0013\t\u0005C\u0005\u0003L\u001d\n\t\u0011\"!\u0003N!I!1L\u0014\u0002\u0002\u0013%!Q\f\u0002\u000f\u001b\u0006\\W\r\u0012+J]R,'O^1m\u0015\ty\u0003'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u00193\u0003!\u0019\u0017\r^1msN$(BA\u001a5\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003kY\nQa\u001d9be.T!a\u000e\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0014aA8sO\u000e\u00011C\u0002\u0001=\u0001\u000e3E\n\u0005\u0002>}5\ta&\u0003\u0002@]\t!\u0012+^1uKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!P!\n\u0005\ts#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005u\"\u0015BA#/\u0005M\u0019V\u000f\u001d9peR\fV/\u001a:z\u0007>tG/\u001a=u!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u001d\u0001&o\u001c3vGR\u0004\"!T+\u000f\u00059\u001bfBA(S\u001b\u0005\u0001&BA);\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002U\u0011\u00069\u0001/Y2lC\u001e,\u0017B\u0001,X\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!\u0006*\u0001\u0003eCf\u001cX#\u0001.\u0011\u0005uZ\u0016B\u0001//\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006I\u0006L8\u000fI\u0001\u0006Q>,(o]\u0001\u0007Q>,(o\u001d\u0011\u0002\t5Lgn]\u0001\u0006[&t7\u000fI\u0001\u0005g\u0016\u001c7/A\u0003tK\u000e\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0006M\u001eD\u0017N\u001b\t\u0003{\u0001AQ\u0001W\u0005A\u0002iCQAX\u0005A\u0002iCQ\u0001Y\u0005A\u0002iCQAY\u0005A\u0002i\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001n!\t9e.\u0003\u0002p\u0011\n9!i\\8mK\u0006tG\u0003\u00024reNDQ\u0001W\u0006A\u0002iCQAX\u0006A\u0002iCQ\u0001Y\u0006A\u0002i#2AZ;w\u0011\u0015AF\u00021\u0001[\u0011\u0015qF\u00021\u0001[)\t1\u0007\u0010C\u0003Y\u001b\u0001\u0007!\fF\u0001g\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u00061am\\;si\"\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\t\u0001E\u0003N\u0003\u0007\t9!C\u0002\u0002\u0006]\u00131aU3r!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007e\u0005)A/\u001f9fg&!\u0011\u0011CA\u0006\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t9\u0002\u0005\u0003\u0002\n\u0005e\u0011\u0002BA\u000e\u0003\u0017\u0011\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u000b\u0003C\t9#a\u000b\u00020\u0005M\u0002cA$\u0002$%\u0019\u0011Q\u0005%\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002*U\u0001\r!!\t\u0002\u0007\u0011\f\u0017\u0010C\u0004\u0002.U\u0001\r!!\t\u0002\t!|WO\u001d\u0005\b\u0003c)\u0002\u0019AA\u0011\u0003\ri\u0017N\u001c\u0005\b\u0003k)\u0002\u0019AA\u0011\u0003\r\u0019XmY\u0001\nI><UM\\\"pI\u0016$b!a\u000f\u0002H\u0005E\u0003\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005c&A\u0004d_\u0012,w-\u001a8\n\t\u0005\u0015\u0013q\b\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011\n\fA\u0002\u0005-\u0013aA2uqB!\u0011QHA'\u0013\u0011\ty%a\u0010\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111\u000b\fA\u0002\u0005m\u0012AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00033\u0002B!a\u0017\u0002d9!\u0011QLA0!\ty\u0005*C\u0002\u0002b!\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA3\u0003O\u0012aa\u0015;sS:<'bAA1\u0011\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\nM\u00065\u0014qNA9\u0003gBQ\u0001\u0017\rA\u0002iCQA\u0018\rA\u0002iCQ\u0001\u0019\rA\u0002iCQA\u0019\rA\u0002i\u000b\u0001#\u001b8jiF+XM]=D_:$X\r\u001f;\u0015\u0005\u0005e\u0004#B$\u0002|\u0005}\u0014bAA?\u0011\n1q\n\u001d;j_:\u0004B!!!\u0002\u00046\tA'C\u0002\u0002\u0006R\u0012A\"U;fef\u001cuN\u001c;fqR\fAaY8qsRIa-a#\u0002\u000e\u0006=\u0015\u0011\u0013\u0005\b1j\u0001\n\u00111\u0001[\u0011\u001dq&\u0004%AA\u0002iCq\u0001\u0019\u000e\u0011\u0002\u0003\u0007!\fC\u0004c5A\u0005\t\u0019\u0001.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0013\u0016\u00045\u0006e5FAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0006*\u0001\u0006b]:|G/\u0019;j_:LA!!+\u0002 \n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0006\u0003BA\\\u0003\u0003l!!!/\u000b\t\u0005m\u0016QX\u0001\u0005Y\u0006twM\u0003\u0002\u0002@\u0006!!.\u0019<b\u0013\u0011\t)'!/\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0007cA$\u0002J&\u0019\u00111\u001a%\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0012\u0011\u001b\u0005\n\u0003'\f\u0013\u0011!a\u0001\u0003\u000f\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAm!\u0019\tY.!9\u0002\"5\u0011\u0011Q\u001c\u0006\u0004\u0003?D\u0015AC2pY2,7\r^5p]&!\u00111]Ao\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00075\fI\u000fC\u0005\u0002T\u000e\n\t\u00111\u0001\u0002\"\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t),a<\t\u0013\u0005MG%!AA\u0002\u0005\u001d\u0017AB3rk\u0006d7\u000fF\u0002n\u0003kD\u0011\"a5&\u0003\u0003\u0005\r!!\t)/\u0001\tI0a@\u0003\u0002\t\u0015!q\u0001B\u0006\u0005\u001b\u0011\tBa\u0005\u0003\u0018\te\u0001cA\u001f\u0002|&\u0019\u0011Q \u0018\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1A\u0001m?\u001a+fjQ0)7\u0012\f\u0017p].-A!|WO]:\\Y\u0001j\u0017N\\:\\Y\u0001\u001aXmY:^;vk\u0016\u0006I\u0017!\u001b\u0006\\W\r\t#bsRKW.Z%oi\u0016\u0014h/\u00197UsB,\u0007\u0005Z;sCRLwN\u001c\u0011ge>l\u0007\u0005Z1zg2\u0002\u0003n\\;sg2\u0002S.\u001b8tA\u0005tG\rI:fGNt\u0013!C1sOVlWM\u001c;tC\t\u0011I!\u0001B\u0018\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C-Y=tA5\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u0004C-Y=tY\u0001\u0002xn]5uSZ,\u0007e\u001c:!]\u0016<\u0017\r^5wK*\u0001\u0003\u0005\t\u0011!A)\u0002\u0003n\\;sg\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007\u0005[8veNd\u0003\u0005]8tSRLg/\u001a\u0011pe\u0002rWmZ1uSZ,'\u0002\t\u0011!A\u0001\u0002#\u0006I7j]N\u0004S\u0006\t;iK\u0002rW/\u001c2fe\u0002zg\rI7j]V$Xm\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM,7m\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gAM,7m\u001c8eg\u0002:\u0018\u000e\u001e5!i\",\u0007E\u001a:bGRLwN\\1mAA\f'\u000f\u001e\u0011j]\u0002j\u0017n\u0019:pg\u0016\u001cwN\u001c3!aJ,7-[:j_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0004\u0002\u0003\u0007S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0017!cIb\u0003e\r\u0019-AA\nd\u0006\r\u00192aA\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112AE\u0012$h\r\u0019;aEr\u0003\u0007M\u00191aE\u0002\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)e%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00111ai\u0002\u0004G\u000f\u00191]A\u0002\u0004\u0007\r\u00191aA\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00191a1\u0002c.\u001e7mY\u0001\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\tU\u0011!B\u001a/e9\u0002\u0014!B4s_V\u0004\u0018E\u0001B\u000e\u00039!\u0017\r^3uS6,wLZ;oGN\fa\"T1lK\u0012#\u0016J\u001c;feZ\fG\u000e\u0005\u0002>OM)qEa\t\u00030AI!Q\u0005B\u00165jS&LZ\u0007\u0003\u0005OQ1A!\u000bI\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\f\u0003(\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002>\u0006\u0011\u0011n\\\u0005\u0004-\nMBC\u0001B\u0010\u0003!!xn\u0015;sS:<GCAA[\u0003\u0015\t\u0007\u000f\u001d7z)%1'1\tB#\u0005\u000f\u0012I\u0005C\u0003YU\u0001\u0007!\fC\u0003_U\u0001\u0007!\fC\u0003aU\u0001\u0007!\fC\u0003cU\u0001\u0007!,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t=#q\u000b\t\u0006\u000f\u0006m$\u0011\u000b\t\b\u000f\nM#L\u0017.[\u0013\r\u0011)\u0006\u0013\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\te3&!AA\u0002\u0019\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u0006\u0005\u0003\u00028\n\u0005\u0014\u0002\u0002B2\u0003s\u0013aa\u00142kK\u000e$\b")
public class MakeDTInterval
extends QuaternaryExpression
implements ImplicitCastInputTypes,
SupportQueryContext {
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;
    private Option<QueryContext> queryContext;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(MakeDTInterval x$0) {
        return MakeDTInterval$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Expression>, MakeDTInterval> tupled() {
        return MakeDTInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, MakeDTInterval>>>> curried() {
        return MakeDTInterval$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression first() {
        return this.days();
    }

    @Override
    public Expression second() {
        return this.hours();
    }

    @Override
    public Expression third() {
        return this.mins();
    }

    @Override
    public Expression fourth() {
        return this.secs();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6), (List)Nil$.MODULE$))));
    }

    @Override
    public DataType dataType() {
        return DayTimeIntervalType$.MODULE$.apply();
    }

    @Override
    public Object nullSafeEval(Object day, Object hour, Object min, Object sec) {
        return BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.makeDayTimeInterval(BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, this.origin().context()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(day, hour, min, sec) -> {
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName()), "$");
            return iu + ".makeDayTimeInterval(" + day + ", " + hour + ", " + min + ", " + sec + ", " + errorContext + ")";
        });
    }

    @Override
    public String prettyName() {
        return "make_dt_interval";
    }

    @Override
    public MakeDTInterval withNewChildrenInternal(Expression days, Expression hours, Expression mins, Expression secs) {
        return this.copy(days, hours, mins, secs);
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public MakeDTInterval copy(Expression days, Expression hours, Expression mins, Expression secs) {
        return new MakeDTInterval(days, hours, mins, secs);
    }

    public Expression copy$default$1() {
        return this.days();
    }

    public Expression copy$default$2() {
        return this.hours();
    }

    public Expression copy$default$3() {
        return this.mins();
    }

    public Expression copy$default$4() {
        return this.secs();
    }

    @Override
    public String productPrefix() {
        return "MakeDTInterval";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.days();
            }
            case 1: {
                return this.hours();
            }
            case 2: {
                return this.mins();
            }
            case 3: {
                return this.secs();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeDTInterval;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "days";
            }
            case 1: {
                return "hours";
            }
            case 2: {
                return "mins";
            }
            case 3: {
                return "secs";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeDTInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeDTInterval makeDTInterval = (MakeDTInterval)x$1;
        Expression expression = this.days();
        Expression expression2 = makeDTInterval.days();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.hours();
        Expression expression4 = makeDTInterval.hours();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mins();
        Expression expression6 = makeDTInterval.mins();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.secs();
        Expression expression8 = makeDTInterval.secs();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!makeDTInterval.canEqual(this)) return false;
        return true;
    }

    public MakeDTInterval(Expression days, Expression hours, Expression mins, Expression secs) {
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        ExpectsInputTypes.$init$(this);
        SupportQueryContext.$init$(this);
    }

    public MakeDTInterval(Expression days, Expression hours, Expression mins) {
        this(days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
    }

    public MakeDTInterval(Expression days, Expression hours) {
        this(days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeDTInterval(Expression days) {
        this(days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeDTInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

