/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryCollection;
import org.apache.spark.sql.catalyst.util.geo.LineString;
import org.apache.spark.sql.catalyst.util.geo.MultiLineString;
import org.apache.spark.sql.catalyst.util.geo.MultiPoint;
import org.apache.spark.sql.catalyst.util.geo.MultiPolygon;
import org.apache.spark.sql.catalyst.util.geo.Point;
import org.apache.spark.sql.catalyst.util.geo.Polygon;

public abstract class GeometryModel {
    protected final GeoTypeId typeId;
    protected int sridValue;
    protected final boolean hasZ;
    protected final boolean hasM;

    protected GeometryModel(GeoTypeId typeId, int srid, boolean hasZ, boolean hasM) {
        this.typeId = typeId;
        this.sridValue = srid;
        this.hasZ = hasZ;
        this.hasM = hasM;
    }

    GeoTypeId getTypeId() {
        return this.typeId;
    }

    int srid() {
        return this.sridValue;
    }

    void setSrid(int srid) {
        this.sridValue = srid;
    }

    boolean isEmpty() {
        return false;
    }

    int getDimensionCount() {
        return 2;
    }

    boolean hasZ() {
        return this.hasZ;
    }

    boolean hasM() {
        return this.hasM;
    }

    boolean isPoint() {
        return this instanceof Point;
    }

    boolean isLineString() {
        return this instanceof LineString;
    }

    boolean isPolygon() {
        return this instanceof Polygon;
    }

    boolean isMultiPoint() {
        return this instanceof MultiPoint;
    }

    boolean isMultiLineString() {
        return this instanceof MultiLineString;
    }

    boolean isMultiPolygon() {
        return this instanceof MultiPolygon;
    }

    boolean isGeometryCollection() {
        return this instanceof GeometryCollection;
    }

    Point asPoint() {
        if (this.isPoint()) {
            return (Point)this;
        }
        throw new ClassCastException("Cannot cast " + this.getClass().getSimpleName() + " to Point");
    }

    LineString asLineString() {
        if (this.isLineString()) {
            return (LineString)this;
        }
        throw new ClassCastException("Cannot cast " + this.getClass().getSimpleName() + " to LineString");
    }

    Polygon asPolygon() {
        if (this.isPolygon()) {
            return (Polygon)this;
        }
        throw new ClassCastException("Cannot cast " + this.getClass().getSimpleName() + " to Polygon");
    }

    MultiPoint asMultiPoint() {
        if (this.isMultiPoint()) {
            return (MultiPoint)this;
        }
        throw new ClassCastException("Cannot cast " + this.getClass().getSimpleName() + " to MultiPoint");
    }

    MultiLineString asMultiLineString() {
        if (this.isMultiLineString()) {
            return (MultiLineString)this;
        }
        throw new ClassCastException("Cannot cast " + this.getClass().getSimpleName() + " to MultiLineString");
    }

    MultiPolygon asMultiPolygon() {
        if (this.isMultiPolygon()) {
            return (MultiPolygon)this;
        }
        throw new ClassCastException("Cannot cast " + this.getClass().getSimpleName() + " to MultiPolygon");
    }

    GeometryCollection asGeometryCollection() {
        if (this.isGeometryCollection()) {
            return (GeometryCollection)this;
        }
        throw new ClassCastException("Cannot cast " + this.getClass().getSimpleName() + " to GeometryCollection");
    }
}

