/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.apache.syncope.core.spring.security.jws.MSEntraAccessTokenJWSVerifier;
import org.springframework.transaction.annotation.Transactional;

public class MSEntraJWTSSOProvider
implements JWTSSOProvider {
    protected final UserDAO userDAO;
    protected final AuthDataAccessor authDataAccessor;
    protected final String tenantId;
    protected final String appId;
    protected final String authUsername;
    protected final Duration clockSkew;
    protected final MSEntraAccessTokenJWSVerifier verifier;

    public MSEntraJWTSSOProvider(UserDAO userDAO, AuthDataAccessor authDataAccessor, String tenantId, String appId, String authUsername, Duration clockSkew, MSEntraAccessTokenJWSVerifier verifier) {
        this.userDAO = userDAO;
        this.authDataAccessor = authDataAccessor;
        this.tenantId = tenantId;
        this.appId = appId;
        this.authUsername = authUsername;
        this.clockSkew = clockSkew;
        this.verifier = verifier;
    }

    @Override
    public String getIssuer() {
        return String.format("https://sts.windows.net/%s/", this.tenantId);
    }

    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return this.verifier.supportedJWSAlgorithms();
    }

    public JCAContext getJCAContext() {
        return this.verifier.getJCAContext();
    }

    public boolean verify(JWSHeader header, byte[] signingInput, Base64URL signature) throws JOSEException {
        return this.verifier.verify(header, signingInput, signature);
    }

    @Override
    @Transactional(readOnly=true)
    public Pair<User, Set<SyncopeGrantedAuthority>> resolve(JWTClaimsSet jwtClaims) {
        User authUser = this.userDAO.findByUsername(this.authUsername);
        Set<Object> authorities = Set.of();
        Instant now = OffsetDateTime.now(ZoneOffset.UTC).toInstant();
        Instant issued = jwtClaims.getIssueTime().toInstant();
        Instant notBefore = jwtClaims.getNotBeforeTime().toInstant();
        Instant expired = jwtClaims.getExpirationTime().toInstant();
        if (authUser != null && jwtClaims.getAudience().contains(this.appId) && now.isAfter(issued.minus(this.clockSkew)) && now.isAfter(notBefore.minus(this.clockSkew)) && now.isBefore(expired.plus(this.clockSkew))) {
            authorities = this.authDataAccessor.getAuthorities(authUser.getUsername(), null);
        }
        return Pair.of((Object)authUser, authorities);
    }
}

