/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretAuthenticator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.exception.CredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RefreshTokenAuthenticator
extends OAuth20ClientIdClientSecretAuthenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RefreshTokenAuthenticator.class);

    public OAuth20RefreshTokenAuthenticator(ServicesManager servicesManager, ServiceFactory webApplicationServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry, PrincipalResolver principalResolver, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ClientSecretValidator clientSecretValidator) {
        super(servicesManager, (ServiceFactory<WebApplicationService>)webApplicationServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, principalResolver, requestParameterResolver, clientSecretValidator);
    }

    @Override
    protected boolean canAuthenticate(WebContext context) {
        Optional grantType = context.getRequestParameter("grant_type");
        Optional clientId = context.getRequestParameter("client_id");
        if (clientId.isPresent() && grantType.isPresent() && OAuth20Utils.isGrantType((String)grantType.get(), OAuth20GrantTypes.REFRESH_TOKEN) && context.getRequestParameter("refresh_token").isPresent()) {
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.getServicesManager(), (String)clientId.get());
            LOGGER.trace("Checking if the client [{}] is eligible for refresh token authentication", clientId.get());
            if (registeredService != null && !OAuth20Utils.doesServiceNeedAuthentication(registeredService)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void validateCredentials(UsernamePasswordCredentials credentials, OAuthRegisteredService registeredService, WebContext context, SessionStore sessionStore) {
        String token = credentials.getPassword();
        LOGGER.trace("Received refresh token [{}] for authentication", (Object)token);
        OAuth20RefreshToken refreshToken = (OAuth20RefreshToken)FunctionUtils.doAndHandle(() -> {
            OAuth20RefreshToken state = (OAuth20RefreshToken)this.getTicketRegistry().getTicket(token, OAuth20RefreshToken.class);
            return state == null || state.isExpired() ? null : state;
        });
        String clientId = credentials.getUsername();
        if (refreshToken == null || refreshToken.isExpired() || !StringUtils.equals((CharSequence)refreshToken.getClientId(), (CharSequence)clientId)) {
            LOGGER.error("Refresh token [{}] is either not found in the ticket registry, has expired or is not related to the client [{}]", (Object)token, (Object)clientId);
            throw new CredentialsException("Invalid token: " + token);
        }
    }
}

