/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http.handler;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

public class RedirectRequestHandler
implements IRequestHandler {
    private final String redirectUrl;
    private final int status;
    private Mode mode = Mode.AUTO;

    public RedirectRequestHandler(String redirectUrl) {
        this(redirectUrl, 302);
    }

    public RedirectRequestHandler(String redirectUrl, int status) {
        if (status != 301 && status != 302 && status != 303) {
            throw new IllegalStateException("Status must be either 301, 302 or 303, but was: " + status);
        }
        this.redirectUrl = Args.notEmpty((String)redirectUrl, (String)"redirectUrl");
        this.status = status;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public int getStatus() {
        return this.status;
    }

    public RedirectRequestHandler mode(Mode mode) {
        this.mode = mode != null ? mode : Mode.AUTO;
        return this;
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
        String url = this.getRedirectUrl();
        String location = url.charAt(0) == '/' ? requestCycle.getUrlRenderer().renderContextRelativeUrl(url) : url;
        WebResponse response = (WebResponse)requestCycle.getResponse();
        if (this.mode == Mode.REDIRECT) {
            response.sendRedirect(location);
        } else if (this.mode == Mode.STATUS) {
            this.setStatus(response, requestCycle, location);
        } else if (this.status == 302) {
            response.sendRedirect(location);
        } else {
            this.setStatus(response, requestCycle, location);
        }
    }

    private void setStatus(WebResponse response, IRequestCycle requestCycle, String location) {
        response.setStatus(this.status);
        if (((WebRequest)requestCycle.getRequest()).isAjax()) {
            response.setHeader("Ajax-Location", location);
        } else {
            response.setHeader("Location", location);
        }
    }

    public static enum Mode {
        REDIRECT,
        STATUS,
        AUTO;

    }
}

