/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public interface Connector {
    public Uid authenticate(String var1, String var2, OperationOptions var3);

    public Uid create(ObjectClass var1, Set<Attribute> var2, OperationOptions var3, AtomicReference<Boolean> var4);

    public Uid update(ObjectClass var1, Uid var2, Set<Attribute> var3, OperationOptions var4, AtomicReference<Boolean> var5);

    public Set<AttributeDelta> updateDelta(ObjectClass var1, Uid var2, Set<AttributeDelta> var3, OperationOptions var4, AtomicReference<Boolean> var5);

    public void delete(ObjectClass var1, Uid var2, OperationOptions var3, AtomicReference<Boolean> var4);

    default public void fullReconciliation(ObjectClass objectClass, SyncResultsHandler handler, OperationOptions options) {
        this.filteredReconciliation(objectClass, null, handler, options);
    }

    default public void filteredReconciliation(ObjectClass objectClass, ReconFilterBuilder filterBuilder, final SyncResultsHandler handler, OperationOptions options) {
        Filter filter = null;
        OperationOptions actualOptions = options;
        if (filterBuilder != null) {
            filter = filterBuilder.build(objectClass);
            actualOptions = filterBuilder.build(objectClass, actualOptions);
        }
        this.search(objectClass, filter, new SearchResultsHandler(){

            public void handleResult(SearchResult result) {
            }

            public boolean handle(ConnectorObject object) {
                return handler.handle(new SyncDeltaBuilder().setObject(object).setDeltaType(SyncDeltaType.CREATE_OR_UPDATE).setToken(new SyncToken((Object)"")).build());
            }
        }, actualOptions);
    }

    public void sync(ObjectClass var1, SyncToken var2, SyncResultsHandler var3, OperationOptions var4);

    public SyncToken getLatestSyncToken(ObjectClass var1);

    public ConnectorObject getObject(ObjectClass var1, Attribute var2, boolean var3, OperationOptions var4);

    public SearchResult search(ObjectClass var1, Filter var2, SearchResultsHandler var3, OperationOptions var4);

    default public SearchResult search(ObjectClass objectClass, Filter filter, SearchResultsHandler handler, int pageSize, String pagedResultsCookie, List<OrderByClause> orderBy, OperationOptions options) {
        OperationOptionsBuilder builder = new OperationOptionsBuilder().setPageSize(Integer.valueOf(pageSize)).setPagedResultsOffset(Integer.valueOf(-1));
        if (pagedResultsCookie != null) {
            builder.setPagedResultsCookie(pagedResultsCookie);
        }
        builder.setSortKeys(orderBy.stream().map(clause -> new SortKey(clause.getField(), clause.getDirection() == OrderByClause.Direction.ASC)).collect(Collectors.toList()));
        builder.setAttributesToGet(options.getAttributesToGet());
        return this.search(objectClass, filter, handler, builder.build());
    }

    public Set<ObjectClassInfo> getObjectClassInfo();

    public void validate();

    public void test();

    public void dispose();

    public ConnInstance getConnInstance();
}

