/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@FunctionalInterface
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public interface Principal
extends Serializable {
    public String getId();

    default public Map<String, List<Object>> getAttributes() {
        return new LinkedHashMap<String, List<Object>>();
    }

    @JsonIgnore
    default public <T> T getSingleValuedAttribute(String name, Class<T> expectedType) {
        if (this.containsAttribute(name)) {
            List<Object> values = this.getAttributes().get(name);
            return values.stream().filter(Objects::nonNull).findFirst().map(expectedType::cast).orElse(null);
        }
        return null;
    }

    @JsonIgnore
    default public Object getSingleValuedAttribute(String name) {
        return this.getSingleValuedAttribute(name, Object.class);
    }

    default public boolean containsAttribute(String name) {
        return this.getAttributes().containsKey(name);
    }

    @JsonIgnore
    @CanIgnoreReturnValue
    default public Principal withAttributes(Map<String, List<Object>> attributes) {
        return this;
    }

    @JsonIgnore
    @CanIgnoreReturnValue
    default public Principal getOwner() {
        return this;
    }
}

