/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.RootCasException;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.config.CasCoreActuatorsConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.HttpClientProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.multitenancy.UnknownTenantException;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.services.web.support.MappedExceptionErrorViewResolver;
import org.apereo.cas.util.spring.RestActuatorControllerEndpoint;
import org.apereo.cas.util.spring.RestActuatorEndpointDiscoverer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CasWebSecurityConfigurer;
import org.apereo.cas.web.CasYamlHttpMessageConverter;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.DefaultArgumentExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.view.CasReloadableMessageBundle;
import org.apereo.cas.web.view.DynamicHtmlView;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.webflow.conversation.NoSuchConversationException;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Core})
@Configuration(value="CasCoreWebConfiguration", proxyBeanMethods=false)
class CasCoreWebConfiguration {
    CasCoreWebConfiguration() {
    }

    @Configuration(value="CasRestActuatorEndpointsConfiguration", proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={DispatcherServlet.class})
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasRestActuatorEndpointsConfiguration {
        CasRestActuatorEndpointsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"restControllerEndpointSupplier"})
        public EndpointsSupplier<RestActuatorControllerEndpoint> restControllerEndpointSupplier(ConfigurableApplicationContext applicationContext, ObjectProvider<PathMapper> endpointPathMappers, ObjectProvider<Collection<EndpointFilter<RestActuatorControllerEndpoint>>> filters) {
            return new RestActuatorEndpointDiscoverer((ApplicationContext)applicationContext, endpointPathMappers.orderedStream().toList(), (Collection)filters.getIfAvailable(Collections::emptyList));
        }
    }

    @Configuration(value="CasActuatorEndpointsConfiguration", proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={DispatcherServlet.class})
    @ConditionalOnManagementPort(value=ManagementPortType.SAME)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Import(value={CasCoreActuatorsConfiguration.class})
    static class CasActuatorEndpointsConfiguration {
        CasActuatorEndpointsConfiguration() {
        }
    }

    @Configuration(value="CasCoreWebEndpointsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class, CorsEndpointProperties.class, WebProperties.class})
    static class CasCoreWebEndpointsConfiguration {
        CasCoreWebEndpointsConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casProtocolEndpointConfigurer"})
        public CasWebSecurityConfigurer<Void> casProtocolEndpointConfigurer() {
            return new CasWebSecurityConfigurer<Void>(this){

                public List<String> getIgnoredEndpoints() {
                    return List.of(Strings.CI.prependIfMissing("/login", (CharSequence)"/", new CharSequence[0]), Strings.CI.prependIfMissing("/logout", (CharSequence)"/", new CharSequence[0]), Strings.CI.prependIfMissing("/validate", (CharSequence)"/", new CharSequence[0]), Strings.CI.prependIfMissing("/serviceValidate", (CharSequence)"/", new CharSequence[0]), Strings.CI.prependIfMissing("/p3/serviceValidate", (CharSequence)"/", new CharSequence[0]), Strings.CI.prependIfMissing("/proxyValidate", (CharSequence)"/", new CharSequence[0]), Strings.CI.prependIfMissing("/p3/proxyValidate", (CharSequence)"/", new CharSequence[0]), Strings.CI.prependIfMissing("/proxy", (CharSequence)"/", new CharSequence[0]));
                }
            };
        }
    }

    @Configuration(value="CasCoreWebViewsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebViewsConfiguration {
        CasCoreWebViewsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"dynamicHtmlView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View dynamicHtmlView() {
            return (model, request, response) -> {
                String html = (String)Objects.requireNonNull(model).get(DynamicHtmlView.class.getName());
                new DynamicHtmlView(html).render(model, request, response);
            };
        }
    }

    @Configuration(value="CasCoreWebRequestsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebRequestsConfiguration {
        CasCoreWebRequestsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"argumentExtractor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ArgumentExtractor argumentExtractor(List<ServiceFactoryConfigurer> configurers) {
            AnnotationAwareOrderComparator.sortIfNecessary(configurers);
            List serviceFactoryList = configurers.stream().flatMap(configurer -> configurer.buildServiceFactories().stream()).collect(Collectors.toList());
            return new DefaultArgumentExtractor(serviceFactoryList);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"urlValidator"})
        public FactoryBean<UrlValidator> urlValidator(CasConfigurationProperties casProperties) {
            HttpClientProperties httpClient = casProperties.getHttpClient();
            boolean allowLocalLogoutUrls = httpClient.isAllowLocalUrls();
            String authorityValidationRegEx = httpClient.getAuthorityValidationRegex();
            boolean authorityValidationRegExCaseSensitive = httpClient.isAuthorityValidationRegExCaseSensitive();
            return new SimpleUrlValidatorFactoryBean(allowLocalLogoutUrls, authorityValidationRegEx, authorityValidationRegExCaseSensitive);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"yamlHttpMessageConverter"})
        public HttpMessageConverter yamlHttpMessageConverter() {
            return new CasYamlHttpMessageConverter();
        }

        @Bean
        @ConditionalOnMissingBean(name={"defaultMappedExceptionErrorViewResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ErrorViewResolver defaultMappedExceptionErrorViewResolver(WebProperties webProperties, ConfigurableApplicationContext applicationContext) {
            Map<Class<RootCasException>, ModelAndView> mappings = Map.of(UnknownTenantException.class, WebUtils.toModelAndView((HttpStatus)HttpStatus.NOT_FOUND, (String)"error/casUnknownTenantView"), UnauthorizedServiceException.class, WebUtils.toModelAndView((HttpStatus)HttpStatus.FORBIDDEN, (String)"error/casServiceErrorView"), NoSuchConversationException.class, WebUtils.toModelAndView((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY, (String)"error/%s".formatted(HttpStatus.UNPROCESSABLE_ENTITY.value())), RootCasException.class, WebUtils.toModelAndView((HttpStatus)HttpStatus.BAD_REQUEST, (String)"error/casServiceErrorView"));
            return new MappedExceptionErrorViewResolver((ApplicationContext)applicationContext, webProperties.getResources(), mappings, errorContext -> Optional.empty());
        }
    }

    @Configuration(value="CasCoreWebMessageSourceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreWebMessageSourceConfiguration {
        CasCoreWebMessageSourceConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casCommonMessages"})
        public PropertiesFactoryBean casCommonMessages(CasConfigurationProperties casProperties) {
            PropertiesFactoryBean properties = new PropertiesFactoryBean();
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            List commonNames = casProperties.getMessageBundle().getCommonNames();
            List resourceList = commonNames.stream().map(arg_0 -> ((DefaultResourceLoader)resourceLoader).getResource(arg_0)).collect(Collectors.toList());
            resourceList.add(resourceLoader.getResource("classpath:/cas_common_messages.properties"));
            properties.setLocations((Resource[])resourceList.toArray(Resource[]::new));
            properties.setSingleton(true);
            properties.setIgnoreResourceNotFound(true);
            return properties;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"casMessageSource"})
        public MessageSource messageSource(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties, @Qualifier(value="casCommonMessages") Properties casCommonMessages) {
            return new CasReloadableMessageBundle(tenantExtractor, casProperties, casCommonMessages);
        }
    }
}

