/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.nimbusds.openid.connect.sdk.federation.trust.TrustChainResolver;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.federation.OidcFederationDefaultEntityStatementService;
import org.apereo.cas.oidc.federation.OidcFederationDefaultJsonWebKeystoreService;
import org.apereo.cas.oidc.federation.OidcFederationDefaultTrustChainResolver;
import org.apereo.cas.oidc.federation.OidcFederationEntityStatementService;
import org.apereo.cas.oidc.federation.OidcFederationJsonWebKeystoreService;
import org.apereo.cas.oidc.federation.OidcFederationTrustChainResolver;
import org.apereo.cas.oidc.federation.OidcWellKnownFederationEndpointController;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.OpenIDConnect}, module="federation", enabledByDefault=false)
@Configuration(value="OidcFederationConfiguration", proxyBeanMethods=false)
class OidcFederationConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcFederationConfiguration.class);

    OidcFederationConfiguration() {
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"oidcWellKnownFederationController"})
    @Bean
    public OidcWellKnownFederationEndpointController oidcWellKnownFederationController(@Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext, @Qualifier(value="oidcFederationEntityStatementService") OidcFederationEntityStatementService oidcFederationEntityStatementService) {
        return new OidcWellKnownFederationEndpointController(oidcConfigurationContext, oidcFederationEntityStatementService);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"oidcFederationWebKeystoreService"})
    public OidcFederationJsonWebKeystoreService oidcFederationWebKeystoreService(CasConfigurationProperties casProperties) throws Exception {
        return new OidcFederationDefaultJsonWebKeystoreService(casProperties.getAuthn().getOidc());
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"oidcFederationEntityStatementService"})
    public OidcFederationEntityStatementService oidcFederationEntityStatementService(@Qualifier(value="oidcFederationWebKeystoreService") OidcFederationJsonWebKeystoreService oidcFederationWebKeystoreService, CasConfigurationProperties casProperties, @Qualifier(value="oidcConfigurationContext") OidcConfigurationContext oidcConfigurationContext) {
        return new OidcFederationDefaultEntityStatementService(oidcFederationWebKeystoreService, oidcConfigurationContext.getDiscoverySettings(), casProperties.getAuthn().getOidc());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"oidcFederationTrustChainResolver"})
    public OidcFederationTrustChainResolver oidcFederationTrustChainResolver(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        List trustChainResolvers = casProperties.getAuthn().getOidc().getFederation().getAuthorityHints().stream().map(EntityID::new).map(TrustChainResolver::new).collect(Collectors.toList());
        Collection resolvers = applicationContext.getBeansOfType(TrustChainResolver.class).values();
        trustChainResolvers.addAll(resolvers);
        return new OidcFederationDefaultTrustChainResolver(trustChainResolvers);
    }
}

