/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.trusted.util.MultifactorAuthenticationTrustUtils;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

public class PasswordManagementMultifactorTrustWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public PasswordManagementMultifactorTrustWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder() + 1);
    }

    protected void doInitialize() {
        Flow pswdFlow;
        PasswordManagementProperties pm = this.casProperties.getAuthn().getPm();
        if (pm.getCore().isEnabled() && this.containsFlowState(pswdFlow = this.getFlow("pswdreset"), "initPasswordReset")) {
            TransitionableState initReset = this.getState(pswdFlow, "initPasswordReset");
            initReset.getExitActionList().add((Action)new ConsumerExecutionAction(requestContext -> {
                MultifactorAuthenticationWebflowUtils.putMultifactorDeviceRegistrationEnabled((RequestContext)requestContext, (boolean)false);
                MultifactorAuthenticationTrustUtils.putMultifactorAuthenticationTrustedDevicesDisabled((RequestContext)requestContext, (boolean)true);
            }));
        }
    }
}

