/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.query;

import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.AttributeIndex;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.query.BaseRegisteredServiceIndexService;
import org.apereo.cas.services.query.RegisteredServiceQuery;
import org.apereo.cas.services.query.RegisteredServiceQueryAttribute;
import org.apereo.cas.services.query.RegisteredServiceQueryIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisteredServiceIndexService
extends BaseRegisteredServiceIndexService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServiceIndexService.class);
    private final IndexedCollection<RegisteredService> indexedRegisteredServices = new ConcurrentIndexedCollection();

    public DefaultRegisteredServiceIndexService(List<ServicesManagerRegisteredServiceLocator> registeredServiceLocators, CasConfigurationProperties casProperties) {
        super(registeredServiceLocators, casProperties);
    }

    public void clear() {
        if (this.isEnabled()) {
            this.indexedRegisteredServices.clear();
        }
    }

    public int count() {
        return this.isEnabled() ? this.indexedRegisteredServices.size() : 0;
    }

    public void initialize() {
        if (this.isEnabled()) {
            this.registeredServiceLocators.forEach(locator -> locator.getRegisteredServiceIndexes().stream().map(RegisteredServiceQueryIndex::getIndex).filter(AttributeIndex.class::isInstance).map(AttributeIndex.class::cast).forEach(index -> {
                LOGGER.debug("Adding registered service index [{}] supplied by [{}]", (Object)index.getAttribute().toString(), (Object)locator.getClass().getSimpleName());
                this.indexedRegisteredServices.addIndex((Index)index);
            }));
        }
    }

    public void indexServices(Collection<RegisteredService> services) {
        if (this.isEnabled()) {
            this.indexedRegisteredServices.clear();
            this.indexedRegisteredServices.addAll(services);
        }
    }

    public Optional<RegisteredService> findServiceBy(long id) {
        return this.isEnabled() ? this.indexedRegisteredServices.stream().filter(registeredService -> registeredService.getId() == id).findFirst() : Optional.empty();
    }

    public Stream<RegisteredService> findServiceBy(RegisteredServiceQuery ... queries) {
        if (this.isEnabled()) {
            List<Query> serviceQueries = Arrays.stream(queries).map(RegisteredServiceQueryAttribute::new).map(RegisteredServiceQueryAttribute::toQuery).toList();
            if (serviceQueries.isEmpty()) {
                LOGGER.trace("No queries were provided to search for services");
                return Stream.empty();
            }
            if (serviceQueries.size() == 1) {
                try (ResultSet results = this.indexedRegisteredServices.retrieve(serviceQueries.getFirst());){
                    Stream stream = results.stream();
                    return stream;
                }
            }
            List<Query> subQueries = serviceQueries.subList(2, serviceQueries.size());
            And query = QueryFactory.and((Query)serviceQueries.getFirst(), (Query)serviceQueries.get(1), subQueries);
            try (ResultSet results = this.indexedRegisteredServices.retrieve((Query)query);){
                Stream stream = results.stream();
                return stream;
            }
        }
        return Stream.empty();
    }

    public void indexService(RegisteredService service) {
        if (this.isEnabled()) {
            this.indexedRegisteredServices.removeIf(registeredService -> registeredService.getId() == service.getId());
            this.indexedRegisteredServices.add((Object)service);
        }
    }

    public boolean matches(RegisteredService registeredService, RegisteredServiceQuery query) {
        RegisteredServiceQueryAttribute queryAttribute = new RegisteredServiceQueryAttribute(query);
        Object propertyValue = queryAttribute.getValue(registeredService, new QueryOptions());
        return query.getValue().equals(propertyValue);
    }
}

