/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.executor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.flow.executor.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

public class EncryptedTranscoder
implements Transcoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedTranscoder.class);
    private final CipherExecutor cipherExecutor;
    private final boolean compression;

    public EncryptedTranscoder(CipherExecutor cipherBean) {
        this(cipherBean, true);
    }

    @Override
    public byte[] encode(Object o) throws IOException {
        if (o == null) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        try (ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();){
            try (ObjectOutputStream out = this.compression ? new ObjectOutputStream(new GZIPOutputStream(outBuffer)) : new ObjectOutputStream(outBuffer);){
                this.writeObjectToOutputStream(o, out);
            }
            catch (NotSerializableException e) {
                LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            }
            byte[] byArray = this.encrypt(outBuffer);
            return byArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object decode(byte[] encoded) throws IOException {
        byte[] data = this.decrypt(encoded);
        try (ByteArrayInputStream inBuffer = new ByteArrayInputStream(data);){
            Object object;
            block13: {
                ObjectInputStream in = this.compression ? new ObjectInputStream(new GZIPInputStream(inBuffer)) : new ObjectInputStream(inBuffer);
                try {
                    object = in.readObject();
                    if (in == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return object;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            throw new IOException("Deserialization error", e);
        }
    }

    protected void writeObjectToOutputStream(Object o, ObjectOutputStream out) throws IOException {
        Object object = o;
        if (AopUtils.isAopProxy((Object)o)) {
            try {
                object = ((Advised)o).getTargetSource().getTarget();
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
            if (object == null) {
                LOGGER.error("Could not determine object [{}] from proxy", (Object)Objects.requireNonNull(o).getClass().getSimpleName());
            }
        }
        if (object != null) {
            out.writeObject(object);
        } else {
            LOGGER.warn("Unable to write object [{}] to the output stream", o);
        }
    }

    protected byte[] encrypt(ByteArrayOutputStream outBuffer) {
        return (byte[])this.cipherExecutor.encode((Object)outBuffer.toByteArray());
    }

    private byte[] decrypt(byte[] encoded) {
        return (byte[])this.cipherExecutor.decode((Object)encoded);
    }

    @Generated
    public EncryptedTranscoder(CipherExecutor cipherExecutor, boolean compression) {
        this.cipherExecutor = cipherExecutor;
        this.compression = compression;
    }
}

