/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Optional;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.internals.graph.BaseJoinProcessorNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StoreFactory;

public class StreamStreamJoinNode<K, V1, V2, VR>
extends BaseJoinProcessorNode<K, V1, V2, VR> {
    private final ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters;
    private final ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters;
    private final StoreFactory thisWindowStoreBuilder;
    private final StoreFactory otherWindowStoreBuilder;
    private final Optional<StoreFactory> outerJoinWindowStoreBuilder;
    private final Joined<K, V1, V2> joined;
    private final boolean enableSpuriousResultFix;
    private final ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters;
    private boolean isSelfJoin;

    private StreamStreamJoinNode(String nodeName, ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VR> valueJoiner, ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters, ProcessorParameters<K, V2, ?, ?> joinOtherProcessParameters, ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters, ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters, ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters, StoreFactory thisStoreFactory, StoreFactory otherStoreFactory, Optional<StoreFactory> outerJoinStoreFactory, Joined<K, V1, V2> joined, boolean enableSpuriousResultFix, ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters) {
        super(nodeName, valueJoiner, joinThisProcessorParameters, joinOtherProcessParameters, joinMergeProcessorParameters, null, null);
        this.thisWindowStoreBuilder = thisStoreFactory;
        this.otherWindowStoreBuilder = otherStoreFactory;
        this.joined = joined;
        this.thisWindowedStreamProcessorParameters = thisWindowedStreamProcessorParameters;
        this.otherWindowedStreamProcessorParameters = otherWindowedStreamProcessorParameters;
        this.outerJoinWindowStoreBuilder = outerJoinStoreFactory;
        this.enableSpuriousResultFix = enableSpuriousResultFix;
        this.selfJoinProcessorParameters = selfJoinProcessorParameters;
    }

    @Override
    public String toString() {
        return "StreamStreamJoinNode{thisWindowedStreamProcessorParameters=" + this.thisWindowedStreamProcessorParameters + ", otherWindowedStreamProcessorParameters=" + this.otherWindowedStreamProcessorParameters + ", thisWindowStoreBuilder=" + this.thisWindowStoreBuilder + ", otherWindowStoreBuilder=" + this.otherWindowStoreBuilder + ", outerJoinWindowStoreBuilder=" + this.outerJoinWindowStoreBuilder + ", joined=" + this.joined + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        String thisProcessorName = this.thisProcessorParameters().processorName();
        String otherProcessorName = this.otherProcessorParameters().processorName();
        String thisWindowedStreamProcessorName = this.thisWindowedStreamProcessorParameters.processorName();
        String otherWindowedStreamProcessorName = this.otherWindowedStreamProcessorParameters.processorName();
        if (this.isSelfJoin) {
            topologyBuilder.addProcessor(this.selfJoinProcessorParameters.processorName(), this.selfJoinProcessorParameters.processorSupplier(), thisWindowedStreamProcessorName);
            topologyBuilder.addStateStore(this.thisWindowStoreBuilder, thisWindowedStreamProcessorName, this.selfJoinProcessorParameters.processorName());
        } else {
            topologyBuilder.addProcessor(thisProcessorName, this.thisProcessorParameters().processorSupplier(), thisWindowedStreamProcessorName);
            topologyBuilder.addProcessor(otherProcessorName, this.otherProcessorParameters().processorSupplier(), otherWindowedStreamProcessorName);
            topologyBuilder.addProcessor(this.mergeProcessorParameters().processorName(), this.mergeProcessorParameters().processorSupplier(), thisProcessorName, otherProcessorName);
            topologyBuilder.addStateStore(this.thisWindowStoreBuilder, thisWindowedStreamProcessorName, otherProcessorName);
            topologyBuilder.addStateStore(this.otherWindowStoreBuilder, otherWindowedStreamProcessorName, thisProcessorName);
            if (this.enableSpuriousResultFix) {
                this.outerJoinWindowStoreBuilder.ifPresent(builder -> topologyBuilder.addStateStore((StoreFactory)builder, thisProcessorName, otherProcessorName));
            }
        }
    }

    public void setSelfJoin() {
        this.isSelfJoin = true;
    }

    public boolean getSelfJoin() {
        return this.isSelfJoin;
    }

    public ProcessorParameters<K, V1, ?, ?> getThisWindowedStreamProcessorParameters() {
        return this.thisWindowedStreamProcessorParameters;
    }

    public ProcessorParameters<K, V2, ?, ?> getOtherWindowedStreamProcessorParameters() {
        return this.otherWindowedStreamProcessorParameters;
    }

    public static <K, V1, V2, VR> StreamStreamJoinNodeBuilder<K, V1, V2, VR> streamStreamJoinNodeBuilder() {
        return new StreamStreamJoinNodeBuilder();
    }

    public static final class StreamStreamJoinNodeBuilder<K, V1, V2, VR> {
        private String nodeName;
        private ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VR> valueJoiner;
        private ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters;
        private ProcessorParameters<K, V2, ?, ?> joinOtherProcessorParameters;
        private ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters;
        private ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters;
        private ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters;
        private StoreFactory thisStoreFactory;
        private StoreFactory otherStoreFactory;
        private Optional<StoreFactory> outerJoinStoreFactory;
        private Joined<K, V1, V2> joined;
        private boolean enableSpuriousResultFix = false;
        private ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters;

        private StreamStreamJoinNodeBuilder() {
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withValueJoiner(ValueJoinerWithKey<? super K, ? super V1, ? super V2, ? extends VR> valueJoiner) {
            this.valueJoiner = valueJoiner;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinThisProcessorParameters(ProcessorParameters<K, V1, ?, ?> joinThisProcessorParameters) {
            this.joinThisProcessorParameters = joinThisProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinOtherProcessorParameters(ProcessorParameters<K, V2, ?, ?> joinOtherProcessParameters) {
            this.joinOtherProcessorParameters = joinOtherProcessParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinMergeProcessorParameters(ProcessorParameters<K, VR, ?, ?> joinMergeProcessorParameters) {
            this.joinMergeProcessorParameters = joinMergeProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withThisWindowedStreamProcessorParameters(ProcessorParameters<K, V1, ?, ?> thisWindowedStreamProcessorParameters) {
            this.thisWindowedStreamProcessorParameters = thisWindowedStreamProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherWindowedStreamProcessorParameters(ProcessorParameters<K, V2, ?, ?> otherWindowedStreamProcessorParameters) {
            this.otherWindowedStreamProcessorParameters = otherWindowedStreamProcessorParameters;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withThisWindowStoreBuilder(StoreFactory thisStoreFactory) {
            this.thisStoreFactory = thisStoreFactory;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherWindowStoreBuilder(StoreFactory otherStoreFactory) {
            this.otherStoreFactory = otherStoreFactory;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOuterJoinWindowStoreBuilder(Optional<StoreFactory> outerJoinWindowStoreBuilder) {
            this.outerJoinStoreFactory = outerJoinWindowStoreBuilder;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoined(Joined<K, V1, V2> joined) {
            this.joined = joined;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withSpuriousResultFixEnabled() {
            this.enableSpuriousResultFix = true;
            return this;
        }

        public StreamStreamJoinNodeBuilder<K, V1, V2, VR> withSelfJoinProcessorParameters(ProcessorParameters<K, V1, ?, ?> selfJoinProcessorParameters) {
            this.selfJoinProcessorParameters = selfJoinProcessorParameters;
            return this;
        }

        public StreamStreamJoinNode<K, V1, V2, VR> build() {
            return new StreamStreamJoinNode(this.nodeName, this.valueJoiner, this.joinThisProcessorParameters, this.joinOtherProcessorParameters, this.joinMergeProcessorParameters, this.thisWindowedStreamProcessorParameters, this.otherWindowedStreamProcessorParameters, this.thisStoreFactory, this.otherStoreFactory, this.outerJoinStoreFactory, this.joined, this.enableSpuriousResultFix, this.selfJoinProcessorParameters);
        }
    }
}

