/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import com.google.common.base.Splitter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class HttpRequestUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestUtils.class);
    public static final HttpClientResponseHandler<ClassicHttpResponse> HTTP_CLIENT_RESPONSE_HANDLER = response -> {
        BasicClassicHttpResponse result = new BasicClassicHttpResponse(response.getCode(), response.getReasonPhrase());
        result.setHeaders(response.getHeaders());
        result.setLocale((Locale)ObjectUtils.getIfNull((Object)response.getLocale(), (Object)Locale.getDefault()));
        result.setVersion((ProtocolVersion)ObjectUtils.getIfNull((Object)response.getVersion(), (Object)HttpVersion.HTTP_1_1));
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                entity.writeTo((OutputStream)output);
                Header contentTypeHeader = response.getFirstHeader("Content-Type");
                String contentType = contentTypeHeader != null ? contentTypeHeader.getValue() : ContentType.APPLICATION_JSON.getMimeType();
                result.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray(), ContentType.parseLenient((CharSequence)contentType)));
            }
        }
        return result;
    };
    private static final int GEO_LOC_LONG_INDEX = 1;
    private static final int GEO_LOC_ACCURACY_INDEX = 2;
    private static final int GEO_LOC_TIME_INDEX = 3;
    private static final int PING_URL_TIMEOUT = 3000;

    public static HttpServletRequest getHttpServletRequestFromRequestAttributes() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return Optional.ofNullable(requestAttributes).map(ServletRequestAttributes::getRequest).orElse(null);
    }

    public static HttpServletResponse getHttpServletResponseFromRequestAttributes() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return Optional.ofNullable(requestAttributes).map(ServletRequestAttributes::getResponse).orElse(null);
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocation(HttpServletRequest request) {
        GeoLocationRequest loc = new GeoLocationRequest();
        if (request != null) {
            String geoLocationParam = request.getParameter("geolocation");
            return HttpRequestUtils.getHttpServletRequestGeoLocation(geoLocationParam);
        }
        return loc;
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocation(String geoLocationParam) {
        GeoLocationRequest loc = new GeoLocationRequest();
        if (StringUtils.isNotBlank((CharSequence)geoLocationParam) && !Strings.CI.equals(geoLocationParam, "unknown")) {
            List geoLocation = Splitter.on((String)",").splitToList((CharSequence)geoLocationParam);
            if (!geoLocation.isEmpty()) {
                loc.setLatitude((String)geoLocation.getFirst());
            }
            if (geoLocation.size() >= 2) {
                loc.setLongitude((String)geoLocation.get(1));
            }
            if (geoLocation.size() >= 3) {
                loc.setAccuracy((String)geoLocation.get(2));
            }
            if (geoLocation.size() >= 4) {
                loc.setTimestamp((String)geoLocation.get(3));
            }
        }
        return loc;
    }

    public static Map<String, String> getRequestHeaders(HttpServletRequest request) {
        Enumeration headerNames;
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        if (request != null && (headerNames = request.getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = StringUtils.stripToEmpty((String)request.getHeader(headerName));
                headers.put(headerName, headerValue);
            }
        }
        return headers;
    }

    public static String getHttpServletRequestUserAgent(HttpServletRequest request) {
        if (request != null) {
            return request.getHeader("User-Agent");
        }
        return null;
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, HttpServletRequest request) {
        return argumentExtractors.stream().map(argumentExtractor -> argumentExtractor.extractService(request)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean doesParameterExist(HttpServletRequest request, String name) {
        String parameter = request.getParameter(name);
        if (StringUtils.isBlank((CharSequence)parameter)) {
            LOGGER.error("Missing request parameter: [{}]", (Object)name);
            return false;
        }
        LOGGER.debug("Found provided request parameter [{}]", (Object)name);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpStatus pingUrl(String location) {
        HttpURLConnection connection = null;
        try {
            URL url = new URI(location).toURL();
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setRequestMethod(HttpMethod.HEAD.name());
            connection.setRequestMethod(HttpMethod.GET.name());
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestProperty("Range", "bytes=0-0");
            HttpStatus httpStatus = HttpStatus.valueOf((int)connection.getResponseCode());
            return httpStatus;
        }
        catch (Exception e) {
            LoggingUtils.error(LOGGER, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return HttpStatus.SERVICE_UNAVAILABLE;
    }

    public static String getFullRequestUrl(HttpServletRequest request) {
        return String.valueOf(request.getRequestURL()) + (String)(request.getQueryString() != null ? "?" + request.getQueryString() : "");
    }

    @Generated
    private HttpRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

