/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import org.apache.ibatis.ognl.ExpressionNode;
import org.apache.ibatis.ognl.NodeType;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public abstract class BooleanExpression
extends ExpressionNode
implements NodeType {
    private static final long serialVersionUID = 8933433183011657435L;
    protected Class<?> getterClass;

    public BooleanExpression(int id) {
        super(id);
    }

    public BooleanExpression(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public Class<?> getGetterClass() {
        return this.getterClass;
    }

    @Override
    public Class<?> getSetterClass() {
        return null;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        try {
            Object value = this.getValueBody(context, target);
            this.getterClass = value != null && Boolean.class.isAssignableFrom(value.getClass()) ? Boolean.TYPE : (value != null ? value.getClass() : Boolean.TYPE);
            String ret = super.toGetSourceString(context, target);
            if ("(false)".equals(ret)) {
                return "false";
            }
            if ("(true)".equals(ret)) {
                return "true";
            }
            return ret;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new UnsupportedCompilationException("evaluation resulted in null expression.");
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }
}

