/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.metadata.rest;

import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.apereo.cas.metadata.CasConfigurationMetadataRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.core.Ordered;

public class ConfigurationMetadataSearchResult
extends ConfigurationMetadataProperty
implements Ordered,
Comparable<ConfigurationMetadataSearchResult> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationMetadataSearchResult.class);
    private static final long serialVersionUID = 7767348341760984539L;
    private static final Pattern PATTERN_DESCRIPTION_CODE = RegexUtils.createPattern((String)"\\{@code (.+)\\}");
    private static final Pattern PATTERN_DESCRIPTION_SEE = RegexUtils.createPattern((String)"@see (.+)");
    private static final Pattern PATTERN_DESCRIPTION_LINK = RegexUtils.createPattern((String)"\\{@link (.+)\\}");
    private int order;
    private String group;
    private boolean requiredProperty;
    private String requiredModule;
    private boolean requiredModuleAutomated;

    public ConfigurationMetadataSearchResult(ConfigurationMetadataProperty prop) {
        try {
            this.setDefaultValue(prop.getDefaultValue());
            this.setDeprecation(prop.getDeprecation());
            this.setDescription(ConfigurationMetadataSearchResult.cleanUpDescription(prop.getDescription()));
            this.setShortDescription(ConfigurationMetadataSearchResult.cleanUpDescription(prop.getShortDescription()));
            this.setId(prop.getId());
            this.setName(prop.getName());
            this.setType(prop.getType());
            this.setGroup(CasConfigurationMetadataRepository.getPropertyGroupId(prop));
            this.setOrder(CasConfigurationMetadataRepository.isCasProperty(prop) ? Integer.MIN_VALUE : Integer.MAX_VALUE);
            List valueHints = prop.getHints().getValueHints();
            valueHints.forEach(hint -> {
                Set values = CollectionUtils.toCollection((Object)hint.getValue());
                if (values.contains(RequiresModule.class.getName())) {
                    this.setRequiredModule(hint.getDescription());
                    this.setRequiredModuleAutomated(values.contains(Boolean.TRUE));
                }
                if (values.contains(RequiredProperty.class.getName())) {
                    this.setRequiredProperty(true);
                }
            });
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
    }

    private static String cleanUpDescription(String propDescription) {
        String description = propDescription;
        String format = "<pre>%s</pre>";
        if (StringUtils.isNotBlank((CharSequence)description)) {
            String replacement;
            Matcher matcher = PATTERN_DESCRIPTION_CODE.matcher(description);
            if (matcher.find()) {
                description = RegExUtils.replacePattern((CharSequence)description, (String)PATTERN_DESCRIPTION_CODE.pattern(), (String)String.format("<pre>%s</pre>", matcher.group(1)));
            }
            if ((matcher = PATTERN_DESCRIPTION_LINK.matcher(description)).find()) {
                replacement = "See ".concat(String.format("<pre>%s</pre>", matcher.group(1)));
                description = RegExUtils.replacePattern((CharSequence)description, (String)PATTERN_DESCRIPTION_LINK.pattern(), (String)replacement);
            }
            if ((matcher = PATTERN_DESCRIPTION_SEE.matcher(description)).find()) {
                replacement = "See ".concat(String.format("<pre>%s</pre>", matcher.group(1)));
                description = RegExUtils.replacePattern((CharSequence)description, (String)PATTERN_DESCRIPTION_SEE.pattern(), (String)replacement);
            }
            return description;
        }
        return propDescription;
    }

    @Override
    public int compareTo(@Nonnull ConfigurationMetadataSearchResult result) {
        return Comparator.comparingInt(ConfigurationMetadataSearchResult::getOrder).thenComparing(ConfigurationMetadataProperty::getName).thenComparing(ConfigurationMetadataSearchResult::getGroup).compare(this, result);
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public boolean isRequiredProperty() {
        return this.requiredProperty;
    }

    @Generated
    public String getRequiredModule() {
        return this.requiredModule;
    }

    @Generated
    public boolean isRequiredModuleAutomated() {
        return this.requiredModuleAutomated;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public void setRequiredProperty(boolean requiredProperty) {
        this.requiredProperty = requiredProperty;
    }

    @Generated
    public void setRequiredModule(String requiredModule) {
        this.requiredModule = requiredModule;
    }

    @Generated
    public void setRequiredModuleAutomated(boolean requiredModuleAutomated) {
        this.requiredModuleAutomated = requiredModuleAutomated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationMetadataSearchResult)) {
            return false;
        }
        ConfigurationMetadataSearchResult other = (ConfigurationMetadataSearchResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        String this$group = this.group;
        String other$group = other.group;
        return !(this$group == null ? other$group != null : !this$group.equals(other$group));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigurationMetadataSearchResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.order;
        String $group = this.group;
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        return result;
    }
}

