/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.authorization.server.policy;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.BooleanProperty;
import com.okta.sdk.impl.resource.DateProperty;
import com.okta.sdk.impl.resource.DefaultVoidResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.IntegerProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.ResourceReference;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.VoidResource;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleActions;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleConditions;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultAuthorizationServerPolicyRule
extends AbstractInstanceResource<AuthorizationServerPolicyRule>
implements AuthorizationServerPolicyRule {
    private static final ResourceReference<AuthorizationServerPolicyRuleActions> actionsProperty = new ResourceReference<AuthorizationServerPolicyRuleActions>("actions", AuthorizationServerPolicyRuleActions.class, false);
    private static final ResourceReference<AuthorizationServerPolicyRuleConditions> conditionsProperty = new ResourceReference<AuthorizationServerPolicyRuleConditions>("conditions", AuthorizationServerPolicyRuleConditions.class, false);
    private static final DateProperty createdProperty = new DateProperty("created");
    private static final StringProperty idProperty = new StringProperty("id");
    private static final DateProperty lastUpdatedProperty = new DateProperty("lastUpdated");
    private static final StringProperty nameProperty = new StringProperty("name");
    private static final IntegerProperty priorityProperty = new IntegerProperty("priority");
    private static final EnumProperty<AuthorizationServerPolicyRule.StatusEnum> statusProperty = new EnumProperty<AuthorizationServerPolicyRule.StatusEnum>("status", AuthorizationServerPolicyRule.StatusEnum.class);
    private static final BooleanProperty systemProperty = new BooleanProperty("system");
    private static final EnumProperty<AuthorizationServerPolicyRule.TypeEnum> typeProperty = new EnumProperty<AuthorizationServerPolicyRule.TypeEnum>("type", AuthorizationServerPolicyRule.TypeEnum.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAuthorizationServerPolicyRule.createPropertyDescriptorMap(actionsProperty, conditionsProperty, createdProperty, idProperty, lastUpdatedProperty, nameProperty, priorityProperty, statusProperty, systemProperty, typeProperty);

    public DefaultAuthorizationServerPolicyRule(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAuthorizationServerPolicyRule(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return AuthorizationServerPolicyRule.class;
    }

    public AuthorizationServerPolicyRuleActions getActions() {
        return this.getResourceProperty(actionsProperty);
    }

    public AuthorizationServerPolicyRule setActions(AuthorizationServerPolicyRuleActions actions) {
        this.setProperty(actionsProperty, (Object)actions);
        return this;
    }

    public AuthorizationServerPolicyRuleConditions getConditions() {
        return this.getResourceProperty(conditionsProperty);
    }

    public AuthorizationServerPolicyRule setConditions(AuthorizationServerPolicyRuleConditions conditions) {
        this.setProperty(conditionsProperty, (Object)conditions);
        return this;
    }

    public Date getCreated() {
        return this.getDateProperty(createdProperty);
    }

    public String getId() {
        return this.getString(idProperty);
    }

    public Date getLastUpdated() {
        return this.getDateProperty(lastUpdatedProperty);
    }

    public String getName() {
        return this.getString(nameProperty);
    }

    public AuthorizationServerPolicyRule setName(String name) {
        this.setProperty(nameProperty, (Object)name);
        return this;
    }

    public Integer getPriority() {
        return this.getIntProperty(priorityProperty);
    }

    public AuthorizationServerPolicyRule setPriority(Integer priority) {
        this.setProperty(priorityProperty, (Object)priority);
        return this;
    }

    public AuthorizationServerPolicyRule.StatusEnum getStatus() {
        return this.getEnumProperty(statusProperty);
    }

    public AuthorizationServerPolicyRule setStatus(AuthorizationServerPolicyRule.StatusEnum status) {
        this.setProperty(statusProperty, (Object)status);
        return this;
    }

    public Boolean getSystem() {
        return this.getBoolean(systemProperty);
    }

    public AuthorizationServerPolicyRule setSystem(Boolean system) {
        this.setProperty(systemProperty, (Object)system);
        return this;
    }

    public AuthorizationServerPolicyRule.TypeEnum getType() {
        return this.getEnumProperty(typeProperty);
    }

    public AuthorizationServerPolicyRule setType(AuthorizationServerPolicyRule.TypeEnum type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public AuthorizationServerPolicyRule update(String authServerId) {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
        return this;
    }

    public void activate(String authServerId) {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/activate");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/activate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void deactivate(String authServerId) {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().create("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "/lifecycle/deactivate", new DefaultVoidResource(this.getDataStore()), this, VoidResource.class, queryArgs, (Map<String, List<String>>)headers);
    }

    public void delete(String authServerId) {
        String ruleId = this.getId();
        Map<String, String> pathArgs = this.getParamsFromHref("/api/v1/authorizationServers/{authServerId}/policies/{policyId}/rules/{ruleId}");
        String policyId = pathArgs.get("policyId");
        Assert.hasText((String)policyId, (String)"'policyId' is required and cannot be null or empty.");
        Assert.hasText((String)authServerId, (String)"'authServerId' is required and cannot be null or empty.");
        Assert.hasText((String)ruleId, (String)"'ruleId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        this.getDataStore().delete("/api/v1/authorizationServers/" + authServerId + "/policies/" + policyId + "/rules/" + ruleId + "", this, queryArgs, (Map<String, List<String>>)headers);
    }
}

