/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.csvdir.database;

import java.io.File;
import java.io.FileFilter;
import net.tirasa.connid.bundles.csvdir.CSVDirConfiguration;

public class FileSystem {
    private final CSVDirConfiguration conf;
    private final File sourcePath;
    private final FileFilter fileFilter;

    public FileSystem(CSVDirConfiguration conf) {
        this.conf = conf;
        this.sourcePath = new File(conf.getSourcePath());
        this.fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileSystem.this.isMatched(file);
            }
        };
    }

    public final File[] getAllCsvFiles() {
        File[] csvFiles = this.sourcePath.listFiles(this.fileFilter);
        return this.returnNewArrayIfCsvFilesIsEmpty(csvFiles);
    }

    public final File getLastModifiedCsvFile() {
        File[] csvFiles = this.getAllCsvFiles();
        long tm = 0L;
        File lastModifiedFile = null;
        for (File file : csvFiles) {
            if (file.lastModified() <= tm) continue;
            tm = file.lastModified();
            lastModifiedFile = file;
        }
        return lastModifiedFile;
    }

    public File[] getLastestChangedFiles(final long startFrom) {
        return this.returnNewArrayIfCsvFilesIsEmpty(this.sourcePath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileSystem.this.isMatched(file) && file.lastModified() > startFrom;
            }
        }));
    }

    public long getHighestTimeStamp(final long startFrom) {
        long res = 0L;
        for (File file : this.returnNewArrayIfCsvFilesIsEmpty(this.sourcePath.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileSystem.this.isMatched(file) && file.lastModified() > startFrom;
            }
        }))) {
            if (file.lastModified() <= res) continue;
            res = file.lastModified();
        }
        return res;
    }

    public long getHighestTimeStamp(File[] csvFiles) {
        long res = 0L;
        for (File file : csvFiles) {
            if (file.lastModified() <= res) continue;
            res = file.lastModified();
        }
        return res;
    }

    private File[] returnNewArrayIfCsvFilesIsEmpty(File[] csvFiles) {
        return csvFiles == null ? new File[]{} : csvFiles;
    }

    private boolean isMatched(File file) {
        return !file.isDirectory() && (file.getName().matches(this.conf.getFileMask()) || file.getName().matches("DEFAULT.*\\.csv"));
    }
}

