/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import io.micrometer.newrelic.NewRelicClientProvider;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicMeterRegistry;
import io.micrometer.newrelic.NewRelicNamingConvention;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicInsightsApiClientProvider
implements NewRelicClientProvider {
    private final Logger logger = LoggerFactory.getLogger(NewRelicInsightsApiClientProvider.class);
    private final NewRelicConfig config;
    final HttpSender httpClient;
    NamingConvention namingConvention;
    private final String insightsEndpoint;

    public NewRelicInsightsApiClientProvider(NewRelicConfig config) {
        this(config, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout()), new NewRelicNamingConvention());
    }

    @Deprecated
    public NewRelicInsightsApiClientProvider(NewRelicConfig config, String proxyHost, int proxyPort) {
        this(config, (HttpSender)new HttpUrlConnectionSender(config.connectTimeout(), config.readTimeout(), new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort))), new NewRelicNamingConvention());
    }

    public NewRelicInsightsApiClientProvider(NewRelicConfig config, HttpSender httpClient) {
        this(config, httpClient, new NewRelicNamingConvention());
    }

    NewRelicInsightsApiClientProvider(NewRelicConfig config, HttpSender httpClient, NamingConvention namingConvention) {
        config.validateForInsightsApi().orThrow();
        this.config = config;
        this.httpClient = httpClient;
        this.namingConvention = namingConvention;
        this.insightsEndpoint = config.uri() + "/v1/accounts/" + config.accountId() + "/events";
    }

    @Override
    public void publish(NewRelicMeterRegistry meterRegistry) {
        for (List batch : MeterPartition.partition((MeterRegistry)meterRegistry, (int)Math.min(this.config.batchSize(), 1000))) {
            this.sendEvents(batch.stream().flatMap(meter2 -> (Stream)meter2.match(gauge -> this.writeGauge((Gauge)gauge), counter -> this.writeCounter((Counter)counter), timer -> this.writeTimer((Timer)timer), distributionSummary -> this.writeSummary((DistributionSummary)distributionSummary), longTaskTimer -> this.writeLongTaskTimer((LongTaskTimer)longTaskTimer), timeGauge -> this.writeTimeGauge((TimeGauge)timeGauge), functionCounter -> this.writeFunctionCounter((FunctionCounter)functionCounter), functionTimer -> this.writeFunctionTimer((FunctionTimer)functionTimer), meter -> this.writeMeter((Meter)meter))));
        }
    }

    @Override
    public Stream<String> writeLongTaskTimer(LongTaskTimer timer) {
        TimeUnit timeUnit = timer.baseTimeUnit();
        return Stream.of(this.event(timer.getId(), new Attribute("activeTasks", timer.activeTasks()), new Attribute("duration", timer.duration(timeUnit)), new Attribute("timeUnit", timeUnit.name().toLowerCase(Locale.ROOT))));
    }

    @Override
    public Stream<String> writeFunctionCounter(FunctionCounter counter) {
        double count = counter.count();
        if (Double.isFinite(count)) {
            return Stream.of(this.event(counter.getId(), new Attribute("throughput", count)));
        }
        return Stream.empty();
    }

    @Override
    public Stream<String> writeCounter(Counter counter) {
        return Stream.of(this.event(counter.getId(), new Attribute("throughput", counter.count())));
    }

    @Override
    public Stream<String> writeGauge(Gauge gauge) {
        double value = gauge.value();
        if (Double.isFinite(value)) {
            return Stream.of(this.event(gauge.getId(), new Attribute("value", value)));
        }
        return Stream.empty();
    }

    @Override
    public Stream<String> writeTimeGauge(TimeGauge gauge) {
        double value = gauge.value();
        if (Double.isFinite(value)) {
            return Stream.of(this.event(gauge.getId(), new Attribute("value", value), new Attribute("timeUnit", gauge.baseTimeUnit().name().toLowerCase(Locale.ROOT))));
        }
        return Stream.empty();
    }

    @Override
    public Stream<String> writeSummary(DistributionSummary summary) {
        return Stream.of(this.event(summary.getId(), new Attribute("count", summary.count()), new Attribute("avg", summary.mean()), new Attribute("total", summary.totalAmount()), new Attribute("max", summary.max())));
    }

    @Override
    public Stream<String> writeTimer(Timer timer) {
        TimeUnit timeUnit = timer.baseTimeUnit();
        return Stream.of(this.event(timer.getId(), new Attribute("count", timer.count()), new Attribute("avg", timer.mean(timeUnit)), new Attribute("totalTime", timer.totalTime(timeUnit)), new Attribute("max", timer.max(timeUnit)), new Attribute("timeUnit", timeUnit.name().toLowerCase(Locale.ROOT))));
    }

    @Override
    public Stream<String> writeFunctionTimer(FunctionTimer timer) {
        TimeUnit timeUnit = timer.baseTimeUnit();
        return Stream.of(this.event(timer.getId(), new Attribute("count", timer.count()), new Attribute("avg", timer.mean(timeUnit)), new Attribute("totalTime", timer.totalTime(timeUnit)), new Attribute("timeUnit", timeUnit.name().toLowerCase(Locale.ROOT))));
    }

    @Override
    public Stream<String> writeMeter(Meter meter) {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        for (Measurement measurement : meter.measure()) {
            double value = measurement.getValue();
            if (!Double.isFinite(value)) continue;
            String name = measurement.getStatistic().getTagValueRepresentation();
            attributes.put(name, new Attribute(name, value));
        }
        if (attributes.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.event(meter.getId(), attributes.values().toArray(new Attribute[0])));
    }

    private String event(Meter.Id id, Attribute ... attributes) {
        if (!this.config.meterNameEventTypeEnabled()) {
            int size = attributes.length;
            Attribute[] newAttrs = Arrays.copyOf(attributes, size + 2);
            String name = id.getConventionName(this.namingConvention);
            newAttrs[size] = new Attribute("metricName", name);
            newAttrs[size + 1] = new Attribute("metricType", id.getType().toString());
            return this.event(id, (Iterable<Tag>)Tags.empty(), newAttrs);
        }
        return this.event(id, (Iterable<Tag>)Tags.empty(), attributes);
    }

    private String event(Meter.Id id, Iterable<Tag> extraTags, Attribute ... attributes) {
        StringBuilder tagsJson = new StringBuilder();
        for (Tag tag : id.getConventionTags(this.namingConvention)) {
            tagsJson.append(",\"").append(StringEscapeUtils.escapeJson((String)tag.getKey())).append("\":\"").append(StringEscapeUtils.escapeJson((String)tag.getValue())).append("\"");
        }
        for (Tag tag : extraTags) {
            tagsJson.append(",\"").append(StringEscapeUtils.escapeJson((String)this.namingConvention.tagKey(tag.getKey()))).append("\":\"").append(StringEscapeUtils.escapeJson((String)this.namingConvention.tagValue(tag.getValue()))).append("\"");
        }
        String eventType = this.getEventType(id, this.config, this.namingConvention);
        return Arrays.stream(attributes).map(attr -> attr.getValue() instanceof Number ? ",\"" + attr.getName() + "\":" + DoubleFormat.wholeOrDecimal((double)((Number)attr.getValue()).doubleValue()) : ",\"" + attr.getName() + "\":\"" + this.namingConvention.tagValue(attr.getValue().toString()) + "\"").collect(Collectors.joining("", "{\"eventType\":\"" + StringEscapeUtils.escapeJson((String)eventType) + "\"", tagsJson + "}"));
    }

    void sendEvents(Stream<String> events) {
        try {
            AtomicInteger totalEvents = new AtomicInteger();
            this.httpClient.post(this.insightsEndpoint).withHeader("X-Insert-Key", this.config.apiKey()).withJsonContent(events.peek(ev -> totalEvents.incrementAndGet()).collect(Collectors.joining(",", "[", "]"))).send().onSuccess(response -> this.logger.debug("successfully sent {} metrics to New Relic.", (Object)totalEvents)).onError(response -> this.logger.error("failed to send metrics to new relic: http {} {}", (Object)response.code(), (Object)response.body()));
        }
        catch (Throwable e) {
            this.logger.warn("failed to send metrics to new relic", e);
        }
    }

    @Override
    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    private static class Attribute {
        private final String name;
        private final Object value;

        private Attribute(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

