/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.configuration;

import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import java.util.Properties;
import java.util.function.BinaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesBasedGreenMailConfigurationBuilder {
    public static final String GREENMAIL_USERS = "greenmail.users";
    public static final String GREENMAIL_USERS_LOGIN = "greenmail.users.login";
    public static final String GREENMAIL_AUTH_DISABLED = "greenmail.auth.disabled";
    public static final String GREENMAIL_SIEVE_IGNORE_DETAIL = "greenmail.sieve.ignore.detail";
    public static final String GREENMAIL_PRELOAD_DIR = "greenmail.preload.dir";
    private static final Pattern USER_PATTERN = Pattern.compile("^([^:]+):(?:(.+)@([^@]+)|(.+))$");

    public GreenMailConfiguration build(Properties properties) {
        String preloadDir;
        String disabledAuthentication;
        GreenMailConfiguration configuration = new GreenMailConfiguration();
        String usersParam = properties.getProperty(GREENMAIL_USERS);
        BinaryOperator<String> loginBuilder = this.configureLoginBuilder(properties);
        if (null != usersParam) {
            String[] usersArray;
            for (String user : usersArray = usersParam.split(",")) {
                this.extractAndAddUser(configuration, loginBuilder, user);
            }
        }
        if (null != (disabledAuthentication = properties.getProperty(GREENMAIL_AUTH_DISABLED))) {
            configuration.withDisabledAuthentication();
        }
        String sieveIgnoreDetail = properties.getProperty(GREENMAIL_SIEVE_IGNORE_DETAIL, "false");
        if (Boolean.TRUE.toString().equalsIgnoreCase(sieveIgnoreDetail)) {
            configuration.withSieveIgnoreDetail();
        }
        if (null != (preloadDir = properties.getProperty(GREENMAIL_PRELOAD_DIR))) {
            configuration.withPreloadDir(preloadDir);
        }
        return configuration;
    }

    private BinaryOperator<String> configureLoginBuilder(Properties properties) {
        String loginType = properties.getProperty(GREENMAIL_USERS_LOGIN);
        if (UsersLoginConfigurationType.EMAIL.name().equalsIgnoreCase(loginType)) {
            return this::buildEmailLogin;
        }
        if (UsersLoginConfigurationType.LOCAL_PART.name().equalsIgnoreCase(loginType)) {
            return this::buildLocalPartLogin;
        }
        return this::buildLocalPartLogin;
    }

    protected String buildEmailLogin(String localPart, String domain) {
        return localPart + '@' + domain;
    }

    protected String buildLocalPartLogin(String localPart, String domain) {
        return localPart;
    }

    protected void extractAndAddUser(GreenMailConfiguration configuration, BinaryOperator<String> buildLogin, String user) {
        Matcher matcher = USER_PATTERN.matcher(user);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Expected format login:pwd[@domain] but got " + user);
        }
        String login = matcher.group(1);
        if (matcher.group(3) != null) {
            String pwd = matcher.group(2);
            String domain = matcher.group(3);
            configuration.withUser(login + '@' + domain, (String)buildLogin.apply(login, domain), pwd);
        } else {
            String pwd = matcher.group(4);
            configuration.withUser(login, pwd);
        }
    }

    private static enum UsersLoginConfigurationType {
        LOCAL_PART,
        EMAIL;

    }
}

