/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth;

import java.util.Objects;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.authentication.credential.OneTimeTokenCredential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.monitor.Monitorable;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

@Monitorable
public class GoogleAuthenticatorAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler
implements MultifactorAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAuthenticatorAuthenticationHandler.class);
    private final OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator;
    private final ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider;

    public GoogleAuthenticatorAuthenticationHandler(String name, PrincipalFactory principalFactory, OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator, Integer order, ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
        super(name, principalFactory, order);
        this.validator = validator;
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return GoogleAuthenticatorTokenCredential.class.isAssignableFrom(clazz);
    }

    public boolean supports(Credential credential) {
        return GoogleAuthenticatorTokenCredential.class.isAssignableFrom(credential.getClass());
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws Throwable {
        GoogleAuthenticatorTokenCredential tokenCredential = (GoogleAuthenticatorTokenCredential)credential;
        Authentication authentication = Objects.requireNonNull(WebUtils.getInProgressAuthentication());
        Objects.requireNonNull(authentication, "No authentication is available to determine the principal");
        GoogleAuthenticatorToken validatedToken = (GoogleAuthenticatorToken)this.validator.validate(authentication, (OneTimeTokenCredential)tokenCredential);
        if (validatedToken != null) {
            String principal = authentication.getPrincipal().getId();
            LOGGER.debug("Validated OTP token [{}] successfully for [{}]", (Object)validatedToken, (Object)principal);
            this.validator.store((OneTimeToken)validatedToken);
            LOGGER.debug("Creating authentication result and building principal for [{}]", (Object)principal);
            return this.createHandlerResult((Credential)tokenCredential, this.principalFactory.createPrincipal(principal));
        }
        LOGGER.warn("Authorization of OTP token [{}] has failed", (Object)credential);
        throw new FailedLoginException("Failed to authenticate code " + String.valueOf(credential));
    }

    @Generated
    public OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> getValidator() {
        return this.validator;
    }

    @Generated
    public ObjectProvider<MultifactorAuthenticationProvider> getMultifactorAuthenticationProvider() {
        return this.multifactorAuthenticationProvider;
    }
}

