/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.account;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredServicePrincipalAccessStrategyEnforcer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.account.AccountAuditActionContext;
import org.apereo.cas.web.flow.account.AccountSingleSignOnSession;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.jooq.lambda.Unchecked;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Transactional(transactionManager="ticketTransactionManager")
public class PrepareAccountProfileViewAction
extends BaseCasWebflowAction {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final TicketRegistry ticketRegistry;
    private final ServicesManager servicesManager;
    private final CasConfigurationProperties casProperties;
    private final AuditTrailExecutionPlan auditTrailManager;
    private final GeoLocationService geoLocationService;
    private final RegisteredServicePrincipalAccessStrategyEnforcer principalAccessStrategyEnforcer;

    protected Event doExecuteInternal(RequestContext requestContext) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        Optional ticketGrantingTicket = (Optional)FunctionUtils.doAndHandle(() -> Optional.of((TicketGrantingTicket)this.ticketRegistry.getTicket(ticketGrantingTicketId, TicketGrantingTicket.class)), throwable -> Optional.empty()).get();
        ticketGrantingTicket.ifPresent(ticket -> {
            WebUtils.putAuthentication((Authentication)ticket.getAuthentication(), (RequestContext)requestContext);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            if (this.casProperties.getView().isAuthorizedServicesOnSuccessfulLogin()) {
                this.buildAuthorizedServices(requestContext, (TicketGrantingTicket)ticket, service);
            }
            this.buildAuditLogRecords(requestContext, (TicketGrantingTicket)ticket);
            this.buildActiveSingleSignOnSessions(requestContext, (TicketGrantingTicket)ticket);
        });
        return this.success();
    }

    protected void buildActiveSingleSignOnSessions(RequestContext requestContext, TicketGrantingTicket ticket) {
        List activeSessions = this.ticketRegistry.getSessionsFor(ticket.getAuthentication().getPrincipal().getId()).map(TicketGrantingTicket.class::cast).map(tgt -> {
            AccountSingleSignOnSession ssoSession = new AccountSingleSignOnSession((TicketGrantingTicket)tgt);
            ssoSession.setGeoLocation((String)FunctionUtils.doIf((boolean)BeanSupplier.isNotProxy((Object)this.geoLocationService), () -> this.geoLocationService.locate(ssoSession.getClientIpAddress()).build(), () -> "N/A").get());
            ssoSession.setPayload((String)FunctionUtils.doUnchecked(() -> MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)ssoSession)));
            return ssoSession;
        }).collect(Collectors.toList());
        WebUtils.putSingleSignOnSessions((RequestContext)requestContext, activeSessions);
    }

    protected void buildAuthorizedServices(RequestContext requestContext, TicketGrantingTicket ticket, WebApplicationService service) {
        Map authzAttributes = CollectionUtils.merge((Map[])new Map[]{ticket.getAuthentication().getAttributes(), ticket.getAuthentication().getPrincipal().getAttributes()});
        List authorizedServices = this.servicesManager.getAllServices().stream().filter(registeredService -> (Boolean)FunctionUtils.doAndHandle(() -> this.principalAccessStrategyEnforcer.authorize(RegisteredServicePrincipalAccessStrategyEnforcer.PrincipalAccessStrategyContext.builder().registeredService(registeredService).principalId(ticket.getAuthentication().getPrincipal().getId()).principalAttributes(authzAttributes).service((Service)service).applicationContext(requestContext.getActiveFlow().getApplicationContext()).build()), throwable -> false).get()).sorted().collect(Collectors.toList());
        WebUtils.putAuthorizedServices((RequestContext)requestContext, authorizedServices);
    }

    protected void buildAuditLogRecords(RequestContext requestContext, TicketGrantingTicket ticket) {
        LocalDateTime sinceDate = LocalDateTime.now(Clock.systemUTC()).minusMonths(2L);
        Map<AuditTrailManager.WhereClauseFields, String> criteria = Map.of(AuditTrailManager.WhereClauseFields.DATE, sinceDate, AuditTrailManager.WhereClauseFields.PRINCIPAL, ticket.getAuthentication().getPrincipal().getId());
        List auditLog = this.auditTrailManager.getAuditRecords(criteria).stream().sorted(Comparator.comparing(AuditActionContext::getWhenActionWasPerformed).reversed()).map(Unchecked.function(entry -> new AccountAuditActionContext((AuditActionContext)entry, MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(entry)))).collect(Collectors.toList());
        FunctionUtils.doIf((!auditLog.isEmpty() ? 1 : 0) != 0, u -> requestContext.getFlowScope().put("auditLog", (Object)auditLog)).accept(auditLog);
    }

    @Generated
    public PrepareAccountProfileViewAction(TicketRegistry ticketRegistry, ServicesManager servicesManager, CasConfigurationProperties casProperties, AuditTrailExecutionPlan auditTrailManager, GeoLocationService geoLocationService, RegisteredServicePrincipalAccessStrategyEnforcer principalAccessStrategyEnforcer) {
        this.ticketRegistry = ticketRegistry;
        this.servicesManager = servicesManager;
        this.casProperties = casProperties;
        this.auditTrailManager = auditTrailManager;
        this.geoLocationService = geoLocationService;
        this.principalAccessStrategyEnforcer = principalAccessStrategyEnforcer;
    }
}

