/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.events.EventCategory;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AuditConfTO;
import org.apache.syncope.common.lib.to.AuditEventTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.common.rest.api.beans.AuditQuery;
import org.apache.syncope.common.rest.api.service.AuditService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class AuditRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 4579786978763032240L;

    public List<OpEvent> confs() {
        return this.getService(AuditService.class).confs().stream().map(conf -> {
            try {
                return OpEvent.fromString((String)conf.getKey());
            }
            catch (Exception e) {
                LOG.error("Unexpected when parsing {}", (Object)conf.getKey(), (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void enableConf(OpEvent opEvent) {
        AuditConfTO audit = new AuditConfTO();
        audit.setKey(opEvent.toString());
        audit.setActive(true);
        this.getService(AuditService.class).setConf(audit);
    }

    public void deleteConf(OpEvent opEvent) {
        block2: {
            try {
                this.getService(AuditService.class).deleteConf(opEvent.toString());
            }
            catch (SyncopeClientException e) {
                if (e.getType() == ClientExceptionType.NotFound) break block2;
                LOG.error("Unexpected error when deleting {}", (Object)opEvent.toString(), (Object)e);
            }
        }
    }

    public List<EventCategory> events() {
        ArrayList<EventCategory> eventCategories = new ArrayList<EventCategory>();
        try {
            this.getService(AuditService.class).events().forEach(opEvent -> {
                EventCategory eventCategory = eventCategories.stream().filter(ec -> opEvent.getType() == ec.getType() && Objects.equals(opEvent.getCategory(), ec.getCategory()) && Objects.equals(opEvent.getSubcategory(), ec.getSubcategory())).findFirst().orElseGet(() -> {
                    EventCategory ec = new EventCategory(opEvent.getType());
                    ec.setCategory(opEvent.getCategory());
                    ec.setSubcategory(opEvent.getSubcategory());
                    eventCategories.add(ec);
                    return ec;
                });
                if (!eventCategory.getOps().contains(opEvent.getOp())) {
                    eventCategory.getOps().add(opEvent.getOp());
                }
            });
        }
        catch (Exception e) {
            LOG.error("Unexpected error when listing Audit events", (Throwable)e);
        }
        return eventCategories;
    }

    public long count(String key, OpEvent.CategoryType type, String category, String op, OpEvent.Outcome outcome) {
        AuditQuery query = (AuditQuery)((AuditQuery.Builder)((AuditQuery.Builder)new AuditQuery.Builder().entityKey(key).page(Integer.valueOf(1))).size(Integer.valueOf(0))).type(type).category(category).op(op).outcome(outcome).build();
        return this.getService(AuditService.class).search(query).getTotalCount();
    }

    public List<AuditEventTO> search(String key, int page, int size, OpEvent.CategoryType type, String category, String op, OpEvent.Outcome outcome, SortParam<String> sort) {
        AuditQuery query = (AuditQuery)((AuditQuery.Builder)((AuditQuery.Builder)((AuditQuery.Builder)new AuditQuery.Builder().entityKey(key).size(Integer.valueOf(size))).page(Integer.valueOf(page))).type(type).category(category).op(op).outcome(outcome).orderBy(AuditRestClient.toOrderBy(sort))).build();
        return this.getService(AuditService.class).search(query).getResult();
    }
}

