/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import org.pac4j.saml.config.SAML2Configuration;
import org.springframework.core.io.UrlResource;

public class SAML2UrlResource
extends UrlResource {
    private final SAML2Configuration saml2Configuration;

    public SAML2UrlResource(URL url, SAML2Configuration saml2Configuration) {
        super(url);
        this.saml2Configuration = saml2Configuration;
    }

    protected void customizeConnection(HttpURLConnection connection) throws IOException {
        super.customizeConnection(connection);
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
            if (this.saml2Configuration.getSslSocketFactory() != null) {
                httpsURLConnection.setSSLSocketFactory(this.saml2Configuration.getSslSocketFactory());
            }
            if (this.saml2Configuration.getHostnameVerifier() != null) {
                httpsURLConnection.setHostnameVerifier(this.saml2Configuration.getHostnameVerifier());
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SAML2UrlResource)) {
            return false;
        }
        SAML2UrlResource other = (SAML2UrlResource)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SAML2Configuration this$saml2Configuration = this.saml2Configuration;
        SAML2Configuration other$saml2Configuration = other.saml2Configuration;
        return !(this$saml2Configuration == null ? other$saml2Configuration != null : !((Object)((Object)this$saml2Configuration)).equals((Object)other$saml2Configuration));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SAML2UrlResource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SAML2Configuration $saml2Configuration = this.saml2Configuration;
        result = result * 59 + ($saml2Configuration == null ? 43 : ((Object)((Object)$saml2Configuration)).hashCode());
        return result;
    }
}

