/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapUtils;
import org.ldaptive.Result;

public class LdapAttribute
extends AbstractFreezable {
    private static final int HASH_CODE_SEED = 10223;
    private static final String[] DEFAULT_BINARY_ATTRIBUTES = new String[]{"photo", "personalSignature", "audio", "jpegPhoto", "javaSerializedData", "thumbnailPhoto", "thumbnailLogo", "userCertificate", "cACertificate", "authorityRevocationList", "certificateRevocationList", "crossCertificatePair", "x500UniqueIdentifier"};
    private static final String[] BINARY_ATTRIBUTES;
    private final Collection<AttributeValue> attributeValues = new LinkedHashSet<AttributeValue>();
    private String attributeName;
    private boolean binary;

    public LdapAttribute() {
    }

    public LdapAttribute(String type) {
        this.setName(type);
    }

    public LdapAttribute(String type, byte[] ... value) {
        this.setName(type);
        this.addBinaryValues(value);
    }

    public LdapAttribute(String type, String ... value) {
        this.setName(type);
        this.addStringValues(value);
    }

    public final void setName(String type) {
        block5: {
            block4: {
                this.assertMutable();
                if (type == null) {
                    throw new IllegalArgumentException("Attribute type cannot be null");
                }
                this.attributeName = type;
                if (this.getOptions().contains("binary")) break block4;
                if (!Stream.of(BINARY_ATTRIBUTES).anyMatch(this.attributeName::equalsIgnoreCase)) break block5;
            }
            this.setBinary(true);
        }
    }

    public final boolean isBinary() {
        return this.binary;
    }

    public final void setBinary(boolean b) {
        this.assertMutable();
        this.binary = b;
    }

    public final void configureBinary(String ... attrNames) {
        this.assertMutable();
        if (this.binary) {
            return;
        }
        if (attrNames != null && attrNames.length > 0) {
            for (String s : attrNames) {
                if (!this.attributeName.equalsIgnoreCase(s)) continue;
                this.binary = true;
                break;
            }
        }
    }

    public final String getName() {
        return this.attributeName;
    }

    public final String getName(boolean withOptions) {
        if (withOptions) {
            return this.attributeName;
        }
        int optionIndex = this.attributeName.indexOf(59);
        return optionIndex > 0 ? this.attributeName.substring(0, optionIndex) : this.attributeName;
    }

    public final List<String> getOptions() {
        String[] split;
        if (this.attributeName.indexOf(59) > 0 && (split = this.attributeName.split(";")).length > 1) {
            return Arrays.stream(split, 1, split.length).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }

    public byte[] getBinaryValue() {
        return this.attributeValues.isEmpty() ? null : this.attributeValues.iterator().next().getValue(true);
    }

    public Collection<byte[]> getBinaryValues() {
        if (this.attributeValues.isEmpty()) {
            return Collections.emptyList();
        }
        return this.attributeValues.stream().map(av -> av.getValue(true)).collect(Collectors.toUnmodifiableList());
    }

    public String getStringValue() {
        if (this.attributeValues.isEmpty()) {
            return null;
        }
        return this.attributeValues.iterator().next().getStringValue(this.binary);
    }

    public Collection<String> getStringValues() {
        if (this.attributeValues.isEmpty()) {
            return Collections.emptyList();
        }
        return this.attributeValues.stream().map(v -> v.getStringValue(this.binary)).collect(Collectors.toUnmodifiableList());
    }

    public <T> T getValue(Function<byte[], T> func) {
        return this.attributeValues.isEmpty() ? null : (T)func.apply(this.attributeValues.iterator().next().getValue(true));
    }

    public <T> Collection<T> getValues(Function<byte[], T> func) {
        return this.attributeValues.stream().map(av -> av.getValue(true)).map(func).collect(Collectors.toUnmodifiableList());
    }

    public void addBinaryValues(byte[] ... value) {
        this.assertMutable();
        Stream.of(value).filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, true)).forEach(this.attributeValues::add);
    }

    public void addBinaryValues(Collection<byte[]> values) {
        this.assertMutable();
        values.stream().filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, true)).forEach(this.attributeValues::add);
    }

    void addBinaryValuesInternal(Collection<byte[]> values) {
        this.assertMutable();
        values.stream().map(b -> new AttributeValue((byte[])b, false)).forEach(this.attributeValues::add);
    }

    public void addStringValues(String ... value) {
        this.assertMutable();
        Stream.of(value).filter(Objects::nonNull).map(s -> AttributeValue.fromString(s, this.binary)).forEach(this.attributeValues::add);
    }

    public void addStringValues(Collection<String> values) {
        this.assertMutable();
        values.stream().filter(Objects::nonNull).map(s -> AttributeValue.fromString(s, this.binary)).forEach(this.attributeValues::add);
    }

    public <T> void addValues(Function<T, byte[]> func, T ... value) {
        this.assertMutable();
        Stream.of(value).filter(Objects::nonNull).map(func).filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, true)).forEach(this.attributeValues::add);
    }

    public <T> void addValues(Function<T, byte[]> func, Collection<T> values) {
        this.assertMutable();
        values.stream().filter(Objects::nonNull).map(func).filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, true)).forEach(this.attributeValues::add);
    }

    public void merge(LdapAttribute attr) {
        this.assertMutable();
        attr.attributeValues.stream().map(AttributeValue::copy).forEach(this.attributeValues::add);
    }

    public void removeBinaryValues(byte[] ... value) {
        this.assertMutable();
        Stream.of(value).filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, false)).forEach(this.attributeValues::remove);
    }

    public void removeBinaryValues(Collection<byte[]> values) {
        this.assertMutable();
        values.stream().filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, false)).forEach(this.attributeValues::remove);
    }

    public void removeStringValues(String ... value) {
        this.assertMutable();
        Stream.of(value).filter(Objects::nonNull).map(s -> AttributeValue.fromString(s, this.binary)).forEach(this.attributeValues::remove);
    }

    public void removeStringValues(Collection<String> values) {
        this.assertMutable();
        values.stream().filter(Objects::nonNull).map(s -> AttributeValue.fromString(s, this.binary)).forEach(this.attributeValues::remove);
    }

    public <T> void removeValues(Function<T, byte[]> func, T ... value) {
        this.assertMutable();
        Stream.of(value).filter(Objects::nonNull).map(func).filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, false)).forEach(this.attributeValues::remove);
    }

    public <T> void removeValues(Function<T, byte[]> func, Collection<T> values) {
        this.assertMutable();
        values.stream().filter(Objects::nonNull).map(func).filter(Objects::nonNull).map(b -> new AttributeValue((byte[])b, false)).forEach(this.attributeValues::remove);
    }

    public boolean hasValue(byte[] value) {
        return this.attributeValues.stream().anyMatch(av -> av.equalsValue(value));
    }

    public boolean hasValue(String value) {
        return this.attributeValues.stream().anyMatch(av -> av.equalsValue(value, this.binary));
    }

    public <T> boolean hasValue(Function<T, byte[]> func, T value) {
        return this.attributeValues.stream().anyMatch(av -> av.equalsValue((byte[])func.apply(value)));
    }

    public final int size() {
        return this.attributeValues.size();
    }

    public final void clear() {
        this.assertMutable();
        this.attributeValues.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LdapAttribute) {
            LdapAttribute v = (LdapAttribute)o;
            return LdapUtils.areEqual(LdapUtils.toLowerCase(this.attributeName), LdapUtils.toLowerCase(v.attributeName)) && LdapUtils.areEqual(this.attributeValues, v.attributeValues);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(10223, LdapUtils.toLowerCase(this.attributeName), this.attributeValues);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::name=" + this.attributeName + ", values=" + String.valueOf(this.getEncodedAttributeValues()) + ", binary=" + this.binary;
    }

    private Collection<String> getEncodedAttributeValues() {
        boolean shouldBase64Encode;
        if (Result.ENCODE_CNTRL_CHARS && !this.binary && (shouldBase64Encode = this.attributeValues.stream().anyMatch(av -> LdapUtils.shouldBase64Encode(av.value)))) {
            return this.attributeValues.stream().map(v -> v.getStringValue(true)).collect(Collectors.toUnmodifiableList());
        }
        return this.getStringValues();
    }

    public static LdapAttribute copy(LdapAttribute attr) {
        LdapAttribute ldapAttribute = new LdapAttribute();
        ldapAttribute.attributeName = attr.attributeName;
        for (AttributeValue av : attr.attributeValues) {
            ldapAttribute.attributeValues.add(AttributeValue.copy(av));
        }
        ldapAttribute.binary = attr.binary;
        return ldapAttribute;
    }

    public static LdapAttribute sort(LdapAttribute attr) {
        LdapAttribute sorted = new LdapAttribute(attr.getName());
        if (attr.isBinary()) {
            sorted.setBinary(true);
            attr.getBinaryValues().stream().sorted(new ByteArrayComparator()).forEach(xva$0 -> sorted.addBinaryValues(new byte[][]{xva$0}));
        } else {
            attr.getStringValues().stream().sorted(new StringComparator()).forEach(xva$0 -> sorted.addStringValues((String)xva$0));
        }
        if (attr.isFrozen()) {
            sorted.freeze();
        }
        return sorted;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        String[] split = System.getProperty("org.ldaptive.attribute.binary", "").split(",");
        BINARY_ATTRIBUTES = LdapUtils.concatArrays(DEFAULT_BINARY_ATTRIBUTES, new String[][]{split});
    }

    public static class Builder {
        private final LdapAttribute object = new LdapAttribute();

        protected Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder name(String name) {
            this.object.setName(name);
            return this;
        }

        public <T> Builder values(Function<T, byte[]> func, T ... value) {
            this.object.addValues(func, value);
            return this;
        }

        public Builder values(byte[] ... values) {
            this.object.addBinaryValues(values);
            return this;
        }

        public Builder binaryValues(Collection<byte[]> values) {
            this.object.addBinaryValues(values);
            return this;
        }

        Builder binaryValuesInternal(Collection<byte[]> values) {
            this.object.addBinaryValuesInternal(values);
            return this;
        }

        public Builder values(String ... values) {
            this.object.addStringValues(values);
            return this;
        }

        public Builder stringValues(Collection<String> values) {
            this.object.addStringValues(values);
            return this;
        }

        public Builder binary(boolean b) {
            this.object.setBinary(b);
            return this;
        }

        public LdapAttribute build() {
            return this.object;
        }
    }

    private static final class StringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 4891167994745573424L;

        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }

    private static final class ByteArrayComparator
    implements Comparator<byte[]>,
    Serializable {
        private static final long serialVersionUID = -7798424594763024564L;

        private ByteArrayComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return Arrays.compare(o1, o2);
        }
    }

    private static final class AttributeValue {
        private static final int HASH_CODE_SEED = 10723;
        private final byte[] value;

        AttributeValue(byte[] bytes, boolean copy) {
            if (bytes == null) {
                throw new IllegalArgumentException("Attribute value cannot be null");
            }
            this.value = copy ? LdapUtils.copyArray(bytes) : bytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AttributeValue) {
                AttributeValue v = (AttributeValue)o;
                return LdapUtils.areEqual(this.value, v.value);
            }
            return false;
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(10723, new Object[]{this.value});
        }

        byte[] getValue(boolean copy) {
            return copy ? LdapUtils.copyArray(this.value) : this.value;
        }

        String getStringValue(boolean base64) {
            return base64 ? LdapUtils.base64Encode(this.value) : LdapUtils.utf8Encode(this.value);
        }

        boolean equalsValue(byte[] bytes) {
            return Arrays.equals(this.value, bytes);
        }

        boolean equalsValue(String string, boolean base64) {
            byte[] bytes = base64 ? AttributeValue.base64Decode(string, false) : LdapUtils.utf8Encode(string, false);
            return Arrays.equals(this.value, bytes);
        }

        static AttributeValue fromString(String string, boolean base64) {
            if (base64) {
                return new AttributeValue(AttributeValue.base64Decode(string, true), false);
            }
            return new AttributeValue(LdapUtils.utf8Encode(string, false), false);
        }

        static AttributeValue copy(AttributeValue value) {
            return new AttributeValue(value.getValue(true), false);
        }

        private static byte[] base64Decode(String string, boolean throwOnError) {
            try {
                return LdapUtils.base64Decode(string);
            }
            catch (IllegalArgumentException e) {
                if (throwOnError) {
                    throw new IllegalArgumentException("Error decoding value: " + string, e);
                }
                return null;
            }
        }
    }
}

