/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="AnyTypeClasses")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="anyTypeClasses")
public interface AnyTypeClassService
extends JAXRSService {
    @GET
    @Produces(value={"application/json"})
    public List<AnyTypeClassTO> list();

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public AnyTypeClassTO read(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="201", description="AnyTypeClass successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="Key value for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@NotNull AnyTypeClassTO var1);

    @Parameter(name="key", description="AnyTypeClass's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void update(@NotNull AnyTypeClassTO var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public void delete(@NotNull @PathParam(value="key") String var1);
}

