/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.StatefulConfiguration;

public class OktaConfiguration
extends AbstractConfiguration
implements StatefulConfiguration {
    private String domain;
    private String oktaApiToken;
    private String clientId;
    private String privateKeyPEM;
    private String[] userEvents = new String[]{"user.account.update_profile"};
    private String[] groupEvents = new String[0];
    private String[] applicationEvents = new String[0];
    private int rateLimitMaxRetries = 1;
    private int retryMaxElapsed = 0;
    private int requestTimeout = 20;

    @ConfigurationProperty(order=1, displayMessageKey="domain.display", groupMessageKey="basic.group", helpMessageKey="domain.help", required=true, confidential=false)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @ConfigurationProperty(order=2, displayMessageKey="oktaApiToken.display", groupMessageKey="basic.group", helpMessageKey="oktaApiToken.help", required=false, confidential=true)
    public String getOktaApiToken() {
        return this.oktaApiToken;
    }

    public void setOktaApiToken(String oktaApiToken) {
        this.oktaApiToken = oktaApiToken;
    }

    @ConfigurationProperty(order=3, displayMessageKey="clientId.display", groupMessageKey="basic.group", helpMessageKey="clientId.help", required=false, confidential=false)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ConfigurationProperty(order=4, displayMessageKey="privateKeyPEM.display", groupMessageKey="basic.group", helpMessageKey="privateKeyPEM.help", required=false, confidential=true)
    public String getPrivateKeyPEM() {
        return this.privateKeyPEM;
    }

    public void setPrivateKeyPEM(String privateKeyPEM) {
        this.privateKeyPEM = privateKeyPEM;
    }

    @ConfigurationProperty(order=5, displayMessageKey="userEvents.display", groupMessageKey="basic.group", helpMessageKey="userEvents.help")
    public String[] getUserEvents() {
        return (String[])this.userEvents.clone();
    }

    public void setUserEvents(String ... userEvents) {
        this.userEvents = (String[])userEvents.clone();
    }

    @ConfigurationProperty(order=6, displayMessageKey="groupEvents.display", groupMessageKey="basic.group", helpMessageKey="groupEvents.help")
    public String[] getGroupEvents() {
        return (String[])this.groupEvents.clone();
    }

    public void setGroupEvents(String ... groupEvents) {
        this.groupEvents = (String[])groupEvents.clone();
    }

    @ConfigurationProperty(order=7, displayMessageKey="applicationEvents.display", groupMessageKey="basic.group", helpMessageKey="applicationEvents.help")
    public String[] getApplicationEvents() {
        return (String[])this.applicationEvents.clone();
    }

    public void setApplicationEvents(String ... applicationEvents) {
        this.applicationEvents = (String[])applicationEvents.clone();
    }

    public void setRateLimitMaxRetries(int rateLimitMaxRetries) {
        this.rateLimitMaxRetries = rateLimitMaxRetries;
    }

    @ConfigurationProperty(order=8, displayMessageKey="rateLimitMaxRetries.display", groupMessageKey="basic.group", helpMessageKey="rateLimitMaxRetries.help")
    public int getRateLimitMaxRetries() {
        return this.rateLimitMaxRetries;
    }

    public void setRetryMaxElapsed(int retryMaxElapsed) {
        this.retryMaxElapsed = retryMaxElapsed;
    }

    @ConfigurationProperty(order=9, displayMessageKey="retryMaxElapsed.display", groupMessageKey="basic.group", helpMessageKey="retryMaxElapsed.help")
    public int getRetryMaxElapsed() {
        return this.retryMaxElapsed;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @ConfigurationProperty(order=10, displayMessageKey="requestTimeout.display", groupMessageKey="basic.group", helpMessageKey="requestTimeout.help")
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.domain)) {
            throw new IllegalArgumentException("Domain cannot be null or empty.");
        }
        if (StringUtil.isBlank((String)this.oktaApiToken)) {
            throw new IllegalArgumentException("OktaApiToken cannot be null or empty.");
        }
        if (this.requestTimeout < 0) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
    }

    public void release() {
    }
}

