/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistryQueryCriteria;
import org.apereo.cas.ticket.registry.TicketRegistryStreamCriteria;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.jooq.lambda.Unchecked;

public interface TicketRegistry {
    public static final String BEAN_NAME = "ticketRegistry";

    public Ticket addTicket(Ticket var1) throws Exception;

    default public List<? extends Ticket> addTicket(Stream<? extends Ticket> toSave) {
        return ((Stream)toSave.parallel()).map(Unchecked.function(this::addTicket)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <T extends Ticket> T getTicket(String var1, Class<T> var2);

    public Ticket getTicket(String var1);

    public Ticket getTicket(String var1, Predicate<Ticket> var2);

    public int deleteTicket(String var1) throws Exception;

    public int deleteTicket(Ticket var1) throws Exception;

    default public long deleteAll() {
        return 0L;
    }

    default public Collection<? extends Ticket> getTickets() {
        return List.of();
    }

    default public Stream<? extends Ticket> getTickets(Predicate<Ticket> predicate) {
        return this.stream().filter(predicate);
    }

    public Ticket updateTicket(Ticket var1) throws Exception;

    public long sessionCount();

    public long serviceTicketCount();

    default public Stream<? extends Ticket> stream(TicketRegistryStreamCriteria criteria) {
        return this.getTickets().parallelStream();
    }

    default public Stream<? extends Ticket> stream() {
        return this.stream((TicketRegistryStreamCriteria)TicketRegistryStreamCriteria.builder().build());
    }

    public long countSessionsFor(String var1);

    default public Stream<? extends Ticket> getSessionsFor(String principalId) {
        return this.getTickets(ticket -> {
            if (!(ticket instanceof TicketGrantingTicket)) return false;
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)ticket;
            if (ticket.isExpired()) return false;
            if (!ticketGrantingTicket.getAuthentication().getPrincipal().getId().equals(principalId)) return false;
            return true;
        });
    }

    public Stream<? extends Ticket> getSessionsWithAttributes(Map<String, List<Object>> var1);

    public String digestIdentifier(String var1);

    default public List<? extends Serializable> query(TicketRegistryQueryCriteria criteria) {
        return new ArrayList();
    }

    default public long countTicketsFor(Service service) {
        return 0L;
    }

    default public long countTickets() {
        return this.stream().count();
    }

    public CipherExecutor getCipherExecutor();
}

