/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.admin.MyRemoteLogMetadataManager;
import kafka.admin.MyRemoteLogMetadataManager$;
import kafka.admin.MyRemoteStorageManager;
import kafka.admin.MyRemoteStorageManager$;
import kafka.api.IntegrationTestHarness;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.util.Random$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t}h\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001C\u0011\u0019Y\u0005\u0001)A\u0005\u0007\"IA\n\u0001a\u0001\u0002\u0004%\t!\u0014\u0005\n3\u0002\u0001\r\u00111A\u0005\u0002iC\u0011\u0002\u0019\u0001A\u0002\u0003\u0005\u000b\u0015\u0002(\t\u000f\u0005\u0004\u0001\u0019!C\u0001E\"9a\r\u0001a\u0001\n\u00039\u0007BB5\u0001A\u0003&1\rC\u0004k\u0001\u0001\u0007I\u0011A'\t\u000f-\u0004\u0001\u0019!C\u0001Y\"1a\u000e\u0001Q!\n9Cqa\u001c\u0001A\u0002\u0013\u0005Q\nC\u0004q\u0001\u0001\u0007I\u0011A9\t\rM\u0004\u0001\u0015)\u0003O\u0011\u0015!\b\u0001\"\u0015C\u0011\u0015)\b\u0001\"\u0015w\u0011\u001d\ty\u0001\u0001C)\u0003#Aq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!+\u0001\t\u0003\tY\u000bC\u0004\u00026\u0002!\t!a.\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\bbBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'AqA!\b\u0001\t\u0003\u0011y\u0002C\u0004\u0003*\u0001!\tAa\u000b\t\u000f\tU\u0002\u0001\"\u0001\u00038!9!\u0011\t\u0001\u0005\u0002\t\r\u0003b\u0002B'\u0001\u0011\u0005!q\n\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005OBqA!\u001d\u0001\t\u0003\u0011\u0019\bC\u0004\u0003~\u0001!\tAa \t\u000f\t%\u0005\u0001\"\u0003\u0003\f\"I!q\u001a\u0001\u0012\u0002\u0013%!\u0011\u001b\u0005\b\u0005O\u0004A\u0011\u0002Bu\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005c\u00141CU3n_R,Gk\u001c9jG\u000e\u0013X\u000f\u001a+fgRT!AM\u001a\u0002\u000b\u0005$W.\u001b8\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001oA\u0011\u0001hO\u0007\u0002s)\u0011!hM\u0001\u0004CBL\u0017B\u0001\u001f:\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001@!\t\u0001\u0005!D\u00012\u00035qW/\u001c)beRLG/[8ogV\t1\t\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUIA\u0002J]R\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u000bok6\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u0001\u0016]Vl'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u00035!Xm\u001d;U_BL7MT1nKV\ta\n\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#\u0016k\u0011A\u0015\u0006\u0003'V\na\u0001\u0010:p_Rt\u0014BA+F\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U+\u0015!\u0005;fgR$v\u000e]5d\u001d\u0006lWm\u0018\u0013fcR\u00111L\u0018\t\u0003\trK!!X#\u0003\tUs\u0017\u000e\u001e\u0005\b?\u001e\t\t\u00111\u0001O\u0003\rAH%M\u0001\u000fi\u0016\u001cH\u000fV8qS\u000et\u0015-\\3!\u0003]\u0019\u0018p\u001d*f[>$Xm\u0015;pe\u0006<W-\u00128bE2,G-F\u0001d!\t!E-\u0003\u0002f\u000b\n9!i\\8mK\u0006t\u0017aG:zgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3e?\u0012*\u0017\u000f\u0006\u0002\\Q\"9qLCA\u0001\u0002\u0004\u0019\u0017\u0001G:zgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eA\u000592\u000f^8sC\u001e,W*\u00198bO\u0016\u00148\t\\1tg:\u000bW.Z\u0001\u001cgR|'/Y4f\u001b\u0006t\u0017mZ3s\u00072\f7o\u001d(b[\u0016|F%Z9\u0015\u0005mk\u0007bB0\u000e\u0003\u0003\u0005\rAT\u0001\u0019gR|'/Y4f\u001b\u0006t\u0017mZ3s\u00072\f7o\u001d(b[\u0016\u0004\u0013\u0001G7fi\u0006$\u0017\r^1NC:\fw-\u001a:DY\u0006\u001c8OT1nK\u0006aR.\u001a;bI\u0006$\u0018-T1oC\u001e,'o\u00117bgNt\u0015-\\3`I\u0015\fHCA.s\u0011\u001dy\u0006#!AA\u00029\u000b\u0011$\\3uC\u0012\fG/Y'b]\u0006<WM]\"mCN\u001ch*Y7fA\u0005Y!M]8lKJ\u001cu.\u001e8u\u00035iw\u000eZ5gs\u000e{gNZ5hgR\u00111l\u001e\u0005\u0006qN\u0001\r!_\u0001\u0006aJ|\u0007o\u001d\t\u0004uv|X\"A>\u000b\u0005q,\u0015AC2pY2,7\r^5p]&\u0011ap\u001f\u0002\u0004'\u0016\f\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005kRLGN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\rI\u00181\u0003\u0005\b\u0003+!\u0002\u0019AA\f\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\r\u0003Si!!a\u0007\u000b\u0007i\niB\u0003\u0003\u0002 \u0005\u0005\u0012a\u00026va&$XM\u001d\u0006\u0005\u0003G\t)#A\u0003kk:LGO\u0003\u0002\u0002(\u0005\u0019qN]4\n\t\u0005-\u00121\u0004\u0002\t)\u0016\u001cH/\u00138g_\u0006)1/\u001a;VaR\u00191,!\r\t\u000f\u0005MR\u00031\u0001\u0002\u0018\u0005!\u0011N\u001c4pQ\r)\u0012q\u0007\t\u0005\u00033\tI$\u0003\u0003\u0002<\u0005m!A\u0003\"fM>\u0014X-R1dQ\u0006YC/Z:u\u0007J,\u0017\r^3SK6|G/\u001a+pa&\u001cw+\u001b;i-\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rF\u0002\\\u0003\u0003Ba!a\u0011\u0017\u0001\u0004q\u0015AB9v_J,X\u000eK\u0002\u0017\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0005\u0003\u001b\ni\"\u0001\u0004qCJ\fWn]\u0005\u0005\u0003#\nYEA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDsAFA+\u0003C\n\u0019\u0007\u0005\u0003\u0002X\u0005uSBAA-\u0015\u0011\tY&a\u0013\u0002\u0011A\u0014xN^5eKJLA!a\u0018\u0002Z\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!\u001a\u0002j\u0005\u0012\u0011qM\u0001\u0003u.\f#!a\u001b\u0002\u000b-\u0014\u0018M\u001a;\u0002WQ,7\u000f^\"sK\u0006$XMU3n_R,Gk\u001c9jG^KG\u000f\u001b,bY&$'+\u001a;f]RLwN\\*ju\u0016$2aWA9\u0011\u0019\t\u0019e\u0006a\u0001\u001d\"\u001aq#a\u0012)\u000f]\t)&!\u0019\u0002x1\"\u0011QMA5\u0003Q\"Xm\u001d;De\u0016\fG/\u001a*f[>$X\rV8qS\u000e<\u0016\u000e\u001e5J]\",'/\u001b;fI2{7-\u00197SKR,g\u000e^5p]RKW.\u001a\u000b\u00047\u0006u\u0004BBA\"1\u0001\u0007a\nK\u0002\u0019\u0003\u000fBs\u0001GA+\u0003C\n\u0019\t\f\u0003\u0002f\u0005%\u0014\u0001\u000e;fgR\u001c%/Z1uKJ+Wn\u001c;f)>\u0004\u0018nY,ji\"Le\u000e[3sSR,G\rT8dC2\u0014V\r^3oi&|gnU5{KR\u00191,!#\t\r\u0005\r\u0013\u00041\u0001OQ\rI\u0012q\t\u0015\b3\u0005U\u0013\u0011MAHY\u0011\t)'!\u001b\u0002[Q,7\u000f^\"sK\u0006$XMU3n_R,Gk\u001c9jG^KG\u000f[%om\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rF\u0002\\\u0003+Ca!a\u0011\u001b\u0001\u0004q\u0005f\u0001\u000e\u0002H!:!$!\u0016\u0002b\u0005mE\u0006BA3\u0003S\nQ\u0006^3ti\u000e\u0013X-\u0019;f%\u0016lw\u000e^3U_BL7mV5uQ&sg/\u00197jIJ+G/\u001a8uS>t7+\u001b>f)\rY\u0016\u0011\u0015\u0005\u0007\u0003\u0007Z\u0002\u0019\u0001()\u0007m\t9\u0005K\u0004\u001c\u0003+\n\t'a*-\t\u0005\u0015\u0014\u0011N\u0001!i\u0016\u001cHo\u0011:fCR,7i\\7qC\u000e$X\r\u001a*f[>$Xm\u0015;pe\u0006<W\rF\u0002\\\u0003[Ca!a\u0011\u001d\u0001\u0004q\u0005f\u0001\u000f\u0002H!:A$!\u0016\u0002b\u0005MF\u0006BA3\u0003S\nq\u0007^3ti\u000e\u0013X-\u0019;f%\u0016lw\u000e^3U_BL7mV5uQ\u000e{\u0007/\u001f#jg\u0006\u0014G.\u001a3B]\u0012$U\r\\3uK>sG)[:bE2,GcB.\u0002:\u0006m\u0016q\u0018\u0005\u0007\u0003\u0007j\u0002\u0019\u0001(\t\r\u0005uV\u00041\u0001d\u00031\u0019w\u000e]=ESN\f'\r\\3e\u0011\u0019\t\t-\ba\u0001G\u0006yA-\u001a7fi\u0016|e\u000eR5tC\ndW\rK\u0002\u001e\u0003\u000fBs!HAd\u0003\u001b\fy\r\u0005\u0003\u0002X\u0005%\u0017\u0002BAf\u00033\u0012\u0011bQ:w'>,(oY3\u0002\u000bY\fG.^3-\u0011\u0005E\u0017Q[Am\u0003;\f#!a5\u0002\u001f-\u0014\u0018M\u001a;-iJ,X\r\f;sk\u0016\f#!a6\u0002!-\u0014\u0018M\u001a;-iJ,X\r\f4bYN,\u0017EAAn\u0003AY'/\u00194uY\u0019\fGn]3-iJ,X-\t\u0002\u0002`\u0006\t2N]1gi22\u0017\r\\:fY\u0019\fGn]3\u0002uQ,7\u000f^\"sK\u0006$X\rV8qS\u000e\u0014V\r^3oi&|g.T:WC2LG-\u0019;j_:<\u0016\u000e\u001e5SK6|G/Z\"paf$\u0015n]1cY\u0016$GcA.\u0002f\"1\u00111\t\u0010A\u00029C3AHA$Q\u001dq\u0012QKA1\u0003Wd#!!\u001b\u0002{Q,7\u000f^\"sK\u0006$X\rV8qS\u000e\u0014V\r^3oi&|gNQ=uKN4\u0016\r\\5eCRLwN\\,ji\"\u0014V-\\8uK\u000e{\u0007/\u001f#jg\u0006\u0014G.\u001a3\u0015\u0007m\u000b\t\u0010\u0003\u0004\u0002D}\u0001\rA\u0014\u0015\u0004?\u0005\u001d\u0003fB\u0010\u0002V\u0005\u0005\u0014q\u001f\u0017\u0003\u0003S\na\u0005^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e|e.\u0012=jgRLgn\u001a+pa&\u001cG+Z:u)\rY\u0016Q \u0005\u0007\u0003\u0007\u0002\u0003\u0019\u0001()\u0007\u0001\n9\u0005K\u0004!\u0003+\n\tGa\u0001-\t\u0005\u0015\u0014\u0011N\u00015i\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ,iK:\u001c\u0016p\u001d;f[J+Wn\u001c;f'R|'/Y4f\u0013N$\u0015n]1cY\u0016$GcA.\u0003\n!1\u00111I\u0011A\u00029C3!IA$Q\u001d\t\u0013QKA1\u0005\u001faC!!\u001a\u0002j\u0005yC/Z:u+B$\u0017\r^3U_BL7mQ8oM&<w+\u001b;i-\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o)&lW\rV3tiR\u00191L!\u0006\t\r\u0005\r#\u00051\u0001OQ\r\u0011\u0013q\t\u0015\bE\u0005U\u0013\u0011\rB\u000eY\u0011\t)'!\u001b\u0002_Q,7\u000f^+qI\u0006$X\rV8qS\u000e\u001cuN\u001c4jO^KG\u000f\u001b,bY&$'+\u001a;f]RLwN\\*ju\u0016$Vm\u001d;\u0015\u0007m\u0013\t\u0003\u0003\u0004\u0002D\r\u0002\rA\u0014\u0015\u0004G\u0005\u001d\u0003fB\u0012\u0002V\u0005\u0005$q\u0005\u0017\u0005\u0003K\nI'\u0001\u001buKN$X\u000b\u001d3bi\u0016$v\u000e]5d\u0007>tg-[4XSRD\u0017J\u001c5fe&$X\r\u001a'pG\u0006d'+\u001a;f]RLwN\u001c+j[\u0016$2a\u0017B\u0017\u0011\u0019\t\u0019\u0005\na\u0001\u001d\"\u001aA%a\u0012)\u000f\u0011\n)&!\u0019\u000341\"\u0011QMA5\u0003Q\"Xm\u001d;Va\u0012\fG/\u001a+pa&\u001c7i\u001c8gS\u001e<\u0016\u000e\u001e5J]\",'/\u001b;fI2{7-\u00197SKR,g\u000e^5p]NK'0\u001a\u000b\u00047\ne\u0002BBA\"K\u0001\u0007a\nK\u0002&\u0003\u000fBs!JA+\u0003C\u0012y\u0004\f\u0003\u0002f\u0005%\u0014a\f;fgR,\u0006\u000fZ1uKR{\u0007/[2D_:4\u0017nZ,ji\"$\u0015n]1cY&twMU3n_R,7\u000b^8sC\u001e,GcA.\u0003F!1\u00111\t\u0014A\u00029C3AJA$Q\u001d1\u0013QKA1\u0005\u0017b#!!\u001b\u0002\u0005R,7\u000f^+qI\u0006$X\rV8qS\u000e\u001cuN\u001c4jO^KG\u000f\u001b#jg\u0006\u0014G.\u001b8h%\u0016lw\u000e^3Ti>\u0014\u0018mZ3XSRDG)\u001a7fi\u0016|e\u000eR5tC\ndW\rF\u0002\\\u0005#Ba!a\u0011(\u0001\u0004q\u0005fA\u0014\u0002H!:q%!\u0016\u0002b\t]CFAA5\u0003-\"Xm\u001d;Va\u0012\fG/Z%om\u0006d\u0017\u000e\u001a*f[>$Xm\u0015;pe\u0006<WmQ8oM&<WK\u001c3fej[EcA.\u0003^!1\u00111\t\u0015A\u00029C3\u0001KA$Q\u001dA\u0013QKA1\u0005Gb#!!\u001a\u0002#Q,7\u000f\u001e+pa&\u001cG)\u001a7fi&|g\u000eF\u0002\\\u0005SBa!a\u0011*\u0001\u0004q\u0005fA\u0015\u0002H!:\u0011&!\u0016\u0002b\t=D\u0006BA3\u0003S\nq\b^3ti\u000ecWo\u001d;fe^KG-\u001a#jg\u0006\u0014G.Z7f]R|e\rV5fe\u0016$7\u000b^8sC\u001e,w+\u001b;i\u000b:\f'\r\\3e)&,'/\u001a3U_BL7\rF\u0002\\\u0005kBa!a\u0011+\u0001\u0004q\u0005f\u0001\u0016\u0002H!:!&!\u0016\u0002b\tmD\u0006BA3\u0003S\n1\n^3ti\u000ecWo\u001d;fe^KG\u000f[8viRKWM]3e'R|'/Y4f'R\f'\u000f^:Tk\u000e\u001cWm]:gk2d\u00170\u00134U_BL7mV5uQRKWM]5oO\u0012K7/\u00192mK\u0012$2a\u0017BA\u0011\u0019\t\u0019e\u000ba\u0001\u001d\"\u001a1&a\u0012)\u000f-\n)&!\u0019\u0003\b2\"\u0011QMA5\u0003U\t7o]3siRC'o\\<t\u000bb\u001cW\r\u001d;j_:$\u0002B!$\u0003 \nm&1\u001a\t\u0005\u0005\u001f\u0013IJ\u0004\u0003\u0003\u0012\nUebA)\u0003\u0014&\ta)C\u0002\u0003\u0018\u0016\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u001c\nu%!\u0003+ie><\u0018M\u00197f\u0015\r\u00119*\u0012\u0005\b\u0005Cc\u0003\u0019\u0001BR\u00035)\u0007pY3qi&|g\u000eV=qKB\"!Q\u0015BX!\u0015y%q\u0015BV\u0013\r\u0011I\u000b\u0017\u0002\u0006\u00072\f7o\u001d\t\u0005\u0005[\u0013y\u000b\u0004\u0001\u0005\u0019\tE&qTA\u0001\u0002\u0003\u0015\tAa-\u0003\u0007}#\u0013'\u0005\u0003\u00036\n5\u0005c\u0001#\u00038&\u0019!\u0011X#\u0003\u000f9{G\u000f[5oO\"9!Q\u0018\u0017A\u0002\t}\u0016AC3yK\u000e,H/\u00192mKB!!\u0011\u0019Bd\u001b\t\u0011\u0019M\u0003\u0003\u0003F\u0006m\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\n\t\t%'1\u0019\u0002\u000b\u000bb,7-\u001e;bE2,\u0007\u0002\u0003BgYA\u0005\t\u0019\u0001(\u0002\u000f5,7o]1hK\u0006y\u0012m]:feR$\u0006N]8xg\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM'f\u0001(\u0003V.\u0012!q\u001b\t\u0005\u00053\u0014\u0019/\u0004\u0002\u0003\\*!!Q\u001cBp\u0003%)hn\u00195fG.,GMC\u0002\u0003b\u0016\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Oa7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000ewKJLg-\u001f*f[>$X\rT8h)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u00047\n-\bB\u0002Bw]\u0001\u0007q0A\u0006u_BL7mQ8oM&<\u0017!D8wKJ\u0014\u0018\u000eZ3Qe>\u00048\u000fF\u0001\u0000Q\u001d\u0001!Q_Ag\u0005w\u0004B!!\u0007\u0003x&!!\u0011`A\u000e\u0005\r!\u0016mZ\u0011\u0003\u0005{\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class RemoteTopicCrudTest
extends IntegrationTestHarness {
    private final int numPartitions;
    private final int numReplicationFactor;
    private String testTopicName;
    private boolean sysRemoteStorageEnabled = true;
    private String storageManagerClassName = NoOpRemoteStorageManager.class.getName();
    private String metadataManagerClassName = NoOpRemoteLogMetadataManager.class.getName();

    public int numPartitions() {
        return this.numPartitions;
    }

    public int numReplicationFactor() {
        return this.numReplicationFactor;
    }

    public String testTopicName() {
        return this.testTopicName;
    }

    public void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    public boolean sysRemoteStorageEnabled() {
        return this.sysRemoteStorageEnabled;
    }

    public void sysRemoteStorageEnabled_$eq(boolean x$1) {
        this.sysRemoteStorageEnabled = x$1;
    }

    public String storageManagerClassName() {
        return this.storageManagerClassName;
    }

    public void storageManagerClassName_$eq(String x$1) {
        this.storageManagerClassName = x$1;
    }

    public String metadataManagerClassName() {
        return this.metadataManagerClassName;
    }

    public void metadataManagerClassName_$eq(String x$1) {
        this.metadataManagerClassName = x$1;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.putAll((java.util.Map<?, ?>)this.overrideProps());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.overrideProps(), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        if (((Method)info.getTestMethod().get()).getName().endsWith("SystemRemoteStorageIsDisabled")) {
            this.sysRemoteStorageEnabled_$eq(false);
        }
        if (((Method)info.getTestMethod().get()).getName().equals("testTopicDeletion")) {
            this.storageManagerClassName_$eq(MyRemoteStorageManager.class.getName());
            this.metadataManagerClassName_$eq(MyRemoteLogMetadataManager.class.getName());
        }
        super.setUp(info);
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithValidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        topicConfig.put("local.retention.bytes", "256");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "1001");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInheritedLocalRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "1025");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionTime(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateRemoteTopicWithInvalidRetentionSize(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.bytes", "512");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateCompactedRemoteStorage(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("cleanup.policy", "compact");
        this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
    }

    @ParameterizedTest
    @CsvSource(value={"kraft,true,true", "kraft,true,false", "kraft,false,true", "kraft,false,false"})
    public void testCreateRemoteTopicWithCopyDisabledAndDeleteOnDisable(String quorum, boolean copyDisabled, boolean deleteOnDisable) {
        Properties topicConfig = new Properties();
        topicConfig.put("remote.log.copy.disable", Boolean.toString(copyDisabled));
        topicConfig.put("remote.log.delete.on.disable", Boolean.toString(deleteOnDisable));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicRetentionMsValidationWithRemoteCopyDisabled(String quorum) {
        String testTopicName2 = new StringBuilder(1).append(this.testTopicName()).append("2").toString();
        String testTopicName3 = new StringBuilder(1).append(this.testTopicName()).append("3").toString();
        String errorMsgMs = "When `remote.log.copy.disable` is set to true, the `local.retention.ms` and `retention.ms` must be set to the identical value because there will be no more logs copied to the remote storage.";
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("remote.log.copy.disable", "true");
        topicConfig.put("local.retention.ms", "100");
        topicConfig.put("retention.ms", "1000");
        topicConfig.put("local.retention.bytes", "-2");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Throwable err = this.assertThrowsException(InvalidConfigurationException.class, () -> {
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
        Assertions.assertEquals((Object)errorMsgMs, (Object)err.getMessage());
        topicConfig.put("local.retention.ms", "1000");
        String x$10 = this.testTopicName();
        Buffer<KafkaBroker> x$11 = this.brokers();
        Seq<ControllerServer> x$12 = this.controllerServers();
        int x$13 = this.numPartitions();
        int x$14 = this.numReplicationFactor();
        Map x$16 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$10, x$11, x$12, x$13, x$14, (Map<Object, Seq<Object>>)x$16, topicConfig);
        topicConfig.put("local.retention.ms", "-2");
        Buffer<KafkaBroker> x$19 = this.brokers();
        Seq<ControllerServer> x$20 = this.controllerServers();
        int x$21 = this.numPartitions();
        int x$22 = this.numReplicationFactor();
        Map x$24 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName2, x$19, x$20, x$21, x$22, (Map<Object, Seq<Object>>)x$24, topicConfig);
        topicConfig.clear();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("local.retention.ms", "100");
        topicConfig.put("retention.ms", "1000");
        topicConfig.put("local.retention.bytes", "-2");
        Buffer<KafkaBroker> x$27 = this.brokers();
        Seq<ControllerServer> x$28 = this.controllerServers();
        int x$29 = this.numPartitions();
        int x$30 = this.numReplicationFactor();
        Map x$32 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName3, x$27, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$32, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        Throwable err2 = this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
        Assertions.assertEquals((Object)errorMsgMs, (Object)err2.getMessage());
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "1000"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCreateTopicRetentionBytesValidationWithRemoteCopyDisabled(String quorum) {
        String testTopicName2 = new StringBuilder(1).append(this.testTopicName()).append("2").toString();
        String testTopicName3 = new StringBuilder(1).append(this.testTopicName()).append("3").toString();
        String errorMsgBytes = "When `remote.log.copy.disable` is set to true, the `local.retention.bytes` and `retention.bytes` must be set to the identical value because there will be no more logs copied to the remote storage.";
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("remote.log.copy.disable", "true");
        topicConfig.put("local.retention.bytes", "100");
        topicConfig.put("retention.bytes", "1000");
        topicConfig.put("local.retention.ms", "-2");
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Throwable err = this.assertThrowsException(InvalidConfigurationException.class, () -> {
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        }, "");
        Assertions.assertEquals((Object)errorMsgBytes, (Object)err.getMessage());
        topicConfig.put("local.retention.bytes", "1000");
        String x$10 = this.testTopicName();
        Buffer<KafkaBroker> x$11 = this.brokers();
        Seq<ControllerServer> x$12 = this.controllerServers();
        int x$13 = this.numPartitions();
        int x$14 = this.numReplicationFactor();
        Map x$16 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$10, x$11, x$12, x$13, x$14, (Map<Object, Seq<Object>>)x$16, topicConfig);
        topicConfig.put("local.retention.bytes", "-2");
        Buffer<KafkaBroker> x$19 = this.brokers();
        Seq<ControllerServer> x$20 = this.controllerServers();
        int x$21 = this.numPartitions();
        int x$22 = this.numReplicationFactor();
        Map x$24 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName2, x$19, x$20, x$21, x$22, (Map<Object, Seq<Object>>)x$24, topicConfig);
        topicConfig.clear();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("local.retention.bytes", "100");
        topicConfig.put("retention.bytes", "1000");
        topicConfig.put("local.retention.ms", "-2");
        Buffer<KafkaBroker> x$27 = this.brokers();
        Seq<ControllerServer> x$28 = this.controllerServers();
        int x$29 = this.numPartitions();
        int x$30 = this.numReplicationFactor();
        Map x$32 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, testTopicName3, x$27, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$32, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        Throwable err2 = this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
        Assertions.assertEquals((Object)errorMsgBytes, (Object)err2.getMessage());
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, testTopicName3), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "1000"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogOnExistingTopicTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEnableRemoteLogWhenSystemRemoteStorageIsDisabled(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfigWithRemoteStorage = new Properties();
        topicConfigWithRemoteStorage.put("remote.storage.enable", "true");
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> {
            Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
            String x$2 = this.testTopicName();
            Buffer<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            int x$5 = this.numPartitions();
            int x$6 = this.numReplicationFactor();
            Map x$8 = (Map)Map$.MODULE$.empty();
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfigWithRemoteStorage);
        }, "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
        TestUtils$.MODULE$.createTopicWithAdmin(admin, this.testTopicName(), this.brokers(), this.controllerServers(), this.numPartitions(), this.numReplicationFactor(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        HashMap<ConfigResource, Set<AlterConfigOp>> configs = new HashMap<ConfigResource, Set<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Collections.singleton(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "true"), AlterConfigOp.OpType.SET)));
        Assertions.assertTrue((boolean)this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "").getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionTimeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.ms", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithValidRetentionSizeTest(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "200"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("local.retention.bytes", "100"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        this.verifyRemoteLogTopicConfigs(topicConfig);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionTime(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.ms", "200"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdateTopicConfigWithInheritedLocalRetentionSize(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("retention.bytes", "512"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "Invalid local retention size");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithDisablingRemoteStorage(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "false"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), "It is invalid to disable remote storage without deleting remote data. If you want to keep the remote data and turn to read only, please set `remote.storage.enable=true,remote.log.copy.disable=true`. If you want to disable remote storage and delete all remote data, please set `remote.storage.enable=false,remote.log.delete.on.disable=true`.");
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testUpdateTopicConfigWithDisablingRemoteStorageWithDeleteOnDisable(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.storage.enable", "false"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("remote.log.delete.on.disable", "true"), AlterConfigOp.OpType.SET)));
        admin.incrementalAlterConfigs(configs).all().get();
        Properties newProps = new Properties();
        ((Iterable)configs.get(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()))).forEach(op -> newProps.setProperty(op.configEntry().name(), op.configEntry().value()));
        this.verifyRemoteLogTopicConfigs(newProps);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testUpdateInvalidRemoteStorageConfigUnderZK(String quorum) {
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String errorMsg = "It is invalid to set `remote.log.delete.on.disable` or `remote.log.copy.disable` under Zookeeper's mode.";
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.numReplicationFactor();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(admin, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.copy.disable", "true"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), errorMsg);
        configs.clear();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName()), Arrays.asList(new AlterConfigOp(new ConfigEntry("remote.log.delete.on.disable", "true"), AlterConfigOp.OpType.SET)));
        this.assertThrowsException(InvalidConfigurationException.class, () -> admin.incrementalAlterConfigs((java.util.Map)configs).all().get(), errorMsg);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().set(0);
        int numPartitions = 2;
        Properties topicConfig = new Properties();
        topicConfig.put("remote.storage.enable", "true");
        topicConfig.put("retention.ms", "200");
        topicConfig.put("local.retention.ms", "100");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, numPartitions, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        TestUtils$.MODULE$.deleteTopicWithAdmin(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName(), this.brokers(), this.controllerServers());
        this.assertThrowsException(UnknownTopicOrPartitionException.class, () -> TestUtils$.MODULE$.describeTopic(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()), this.testTopicName()), "Topic should be deleted");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$testTopicDeletion$2(numPartitions)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Remote log segments should be deleted only once by the leader");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWideDisablementOfTieredStorageWithEnabledTieredTopic(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", "true");
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        if (this.isKRaftTest()) {
            boolean x$10 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$10, true);
            Assertions.assertTrue((boolean)(this.faultHandler().firstException().getCause() instanceof ConfigException));
            this.faultHandler().setIgnore(true);
            return;
        }
        Assertions.assertThrows(ConfigException.class, () -> {
            boolean x$12 = this.recreateBrokers$default$1();
            this.recreateBrokers(x$12, true);
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterWithoutTieredStorageStartsSuccessfullyIfTopicWithTieringDisabled(String quorum) {
        Properties topicConfig = new Properties();
        topicConfig.setProperty("remote.storage.enable", Boolean.toString(false));
        Admin x$1 = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        String x$2 = this.testTopicName();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        int x$5 = this.numPartitions();
        int x$6 = this.brokerCount();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$5, x$6, (Map<Object, Seq<Object>>)x$8, topicConfig);
        Properties tsDisabledProps = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head();
        this.instanceConfigs_$eq((Seq<KafkaConfig>)new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(tsDisabledProps), (List)Nil$.MODULE$));
        boolean x$10 = this.recreateBrokers$default$1();
        this.recreateBrokers(x$10, true);
    }

    private Throwable assertThrowsException(Class<? extends Throwable> exceptionType, Executable executable, String message) {
        return Assertions.assertThrows(exceptionType, () -> {
            try {
                executable.execute();
                return;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, (String)message);
    }

    private String assertThrowsException$default$3() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private void verifyRemoteLogTopicConfigs(Properties topicConfig) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$1(this, topicConfig)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RemoteTopicCrudTest.$anonfun$verifyRemoteLogTopicConfigs$3(topicConfig));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Properties overrideProps() {
        Properties props = new Properties();
        props.put("remote.log.storage.system.enable", Boolean.toString(this.sysRemoteStorageEnabled()));
        props.put("remote.log.storage.manager.class.name", this.storageManagerClassName());
        props.put("remote.log.metadata.manager.class.name", this.metadataManagerClassName());
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2000");
        props.put("log.local.retention.ms", "1000");
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "2048");
        props.put("log.local.retention.bytes", "1024");
        return props;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$2(int numPartitions$1) {
        return numPartitions$1 * MyRemoteLogMetadataManager$.MODULE$.segmentCountPerPartition() == MyRemoteStorageManager$.MODULE$.deleteSegmentEventCounter().get();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$3() {
        return "Remote log segments should be deleted only once by the leader";
    }

    public static final /* synthetic */ boolean $anonfun$verifyRemoteLogTopicConfigs$1(RemoteTopicCrudTest $this, Properties topicConfig$6) {
        Buffer logBuffer = (Buffer)$this.brokers().flatMap((Function1 & Serializable)x$2 -> {
            LogManager qual$1 = x$2.logManager();
            TopicPartition x$1 = new TopicPartition($this.testTopicName(), 0);
            boolean x$22 = qual$1.getLog$default$2();
            return qual$1.getLog(x$1, x$22);
        });
        boolean result = logBuffer.nonEmpty();
        if (result) {
            if (topicConfig$6.containsKey("remote.storage.enable")) {
                boolean bl = result = result && StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.storage.enable"))) == ((UnifiedLog)logBuffer.head()).config().remoteStorageEnable();
            }
            if (topicConfig$6.containsKey("local.retention.bytes")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("local.retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionBytes();
            }
            if (topicConfig$6.containsKey("local.retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("local.retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().localRetentionMs();
            }
            if (topicConfig$6.containsKey("retention.ms")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("retention.ms"))) == ((UnifiedLog)logBuffer.head()).config().retentionMs;
            }
            if (topicConfig$6.containsKey("retention.bytes")) {
                boolean bl = result = result && StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("retention.bytes"))) == ((UnifiedLog)logBuffer.head()).config().retentionSize;
            }
            if (topicConfig$6.contains("remote.log.copy.disable")) {
                boolean bl = result = result && BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.log.copy.disable")))), (Object)((UnifiedLog)logBuffer.head()).config().remoteLogCopyDisable());
            }
            if (topicConfig$6.contains("remote.log.delete.on.disable")) {
                result = result && BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig$6.getProperty("remote.log.delete.on.disable")))), (Object)((UnifiedLog)logBuffer.head()).config().remoteLogDeleteOnDisable());
            }
        }
        return result;
    }

    public static final /* synthetic */ String $anonfun$verifyRemoteLogTopicConfigs$3(Properties topicConfig$6) {
        return new StringBuilder(30).append("Failed to update topic config ").append(topicConfig$6).toString();
    }

    public RemoteTopicCrudTest() {
        this.numPartitions = 2;
        this.numReplicationFactor = 2;
    }
}

