/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage;

import java.io.IOException;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.TimerSupport;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.annotation.AnnotationSupport;

public abstract class AbstractStorageService
extends AbstractIdentifiableInitializableComponent
implements StorageService,
StorageCapabilities {
    @Nonnull
    private Duration cleanupInterval = Duration.ZERO;
    @Nullable
    private Timer cleanupTaskTimer;
    @Nullable
    private Timer internalTaskTimer;
    @Nullable
    private TimerTask cleanupTask;
    @Positive
    private int contextSize;
    @Positive
    private int keySize;
    @Positive
    private int valueSize;

    @Nonnull
    public Duration getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(@Nonnull Duration interval) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)interval, (String)"Interval cannot be null");
        Constraint.isFalse((boolean)interval.isNegative(), (String)"Interval cannot be negative");
        this.cleanupInterval = interval;
    }

    @Nullable
    public Timer getCleanupTaskTimer() {
        return this.cleanupTaskTimer;
    }

    public void setCleanupTaskTimer(@Nullable Timer timer) {
        this.checkSetterPreconditions();
        this.cleanupTaskTimer = timer;
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return null;
    }

    public void setContextSize(@Positive int size) {
        this.checkSetterPreconditions();
        this.contextSize = Constraint.isGreaterThan((int)0, (int)size, (String)"Size must be greater than zero");
    }

    public void setKeySize(@Positive int size) {
        this.checkSetterPreconditions();
        this.keySize = Constraint.isGreaterThan((int)0, (int)size, (String)"Size must be greater than zero");
    }

    public void setValueSize(@Positive int size) {
        this.checkSetterPreconditions();
        this.valueSize = Constraint.isGreaterThan((int)0, (int)size, (String)"Size must be greater than zero");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.cleanupInterval.isZero()) {
            this.cleanupTask = this.getCleanupTask();
            if (this.cleanupTask == null) {
                throw new ComponentInitializationException("Cleanup task cannot be null if cleanupInterval is set.");
            }
            this.internalTaskTimer = this.cleanupTaskTimer == null ? new Timer(TimerSupport.getTimerName((Object)this), true) : this.cleanupTaskTimer;
            assert (this.internalTaskTimer != null);
            this.internalTaskTimer.schedule(this.cleanupTask, this.cleanupInterval.toMillis(), this.cleanupInterval.toMillis());
        }
    }

    protected void doDestroy() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
            if (this.cleanupTaskTimer == null) {
                assert (this.internalTaskTimer != null);
                this.internalTaskTimer.cancel();
            }
            this.internalTaskTimer = null;
        }
        super.doDestroy();
    }

    @Override
    @Nonnull
    public StorageCapabilities getCapabilities() {
        return this;
    }

    @Override
    public int getContextSize() {
        return this.contextSize;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public long getValueSize() {
        return this.valueSize;
    }

    @Override
    public <T> boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull T value, @Nonnull StorageSerializer<T> serializer, @Nullable @Positive Long expiration) throws IOException {
        return this.create(context, key, serializer.serialize(value), expiration);
    }

    @Override
    public boolean create(@Nonnull Object value) throws IOException {
        String context = AnnotationSupport.getContext(value);
        String key = AnnotationSupport.getKey(value);
        String val = AnnotationSupport.getValue(value);
        if (context == null || key == null || val == null) {
            throw new IOException("Context, key, and value must be non-null");
        }
        return this.create(context, key, val, AnnotationSupport.getExpiration(value));
    }

    @Override
    @Nullable
    public Object read(@Nonnull Object value) throws IOException {
        String context = AnnotationSupport.getContext(value);
        String key = AnnotationSupport.getKey(value);
        if (context == null || key == null) {
            throw new IOException("Context and key must be non-null");
        }
        StorageRecord record = this.read(context, key);
        if (record != null) {
            AnnotationSupport.setValue(value, record.getValue());
            AnnotationSupport.setExpiration(value, record.getExpiration());
            return value;
        }
        return null;
    }

    @Override
    public <T> boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull T value, @Nonnull StorageSerializer<T> serializer, @Nullable @Positive Long expiration) throws IOException {
        return this.update(context, key, serializer.serialize(value), expiration);
    }

    @Override
    @Nullable
    public <T> Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull T value, @Nonnull StorageSerializer<T> serializer, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        return this.updateWithVersion(version, context, key, serializer.serialize(value), expiration);
    }

    @Override
    public boolean update(@Nonnull Object value) throws IOException {
        String context = AnnotationSupport.getContext(value);
        String key = AnnotationSupport.getKey(value);
        String val = AnnotationSupport.getValue(value);
        if (context == null || key == null || val == null) {
            throw new IOException("Context, key, and value must be non-null");
        }
        return this.update(context, key, val, AnnotationSupport.getExpiration(value));
    }

    @Override
    @Nullable
    public Long updateWithVersion(@Positive long version, @Nonnull Object value) throws IOException, VersionMismatchException {
        String context = AnnotationSupport.getContext(value);
        String key = AnnotationSupport.getKey(value);
        String val = AnnotationSupport.getValue(value);
        if (context == null || key == null || val == null) {
            throw new IOException("Context, key, and value must be non-null");
        }
        return this.updateWithVersion(version, context, key, val, AnnotationSupport.getExpiration(value));
    }

    @Override
    public boolean updateExpiration(@Nonnull Object value) throws IOException {
        String context = AnnotationSupport.getContext(value);
        String key = AnnotationSupport.getKey(value);
        if (context == null || key == null) {
            throw new IOException("Context and key must be non-null");
        }
        return this.updateExpiration(context, key, AnnotationSupport.getExpiration(value));
    }

    @Override
    public boolean delete(@Nonnull Object value) throws IOException {
        String context = AnnotationSupport.getContext(value);
        String key = AnnotationSupport.getKey(value);
        if (context == null || key == null) {
            throw new IOException("Context and key must be non-null");
        }
        return this.delete(context, key);
    }

    @Override
    public boolean deleteWithVersion(@Positive long version, @Nonnull Object value) throws IOException, VersionMismatchException {
        String context = AnnotationSupport.getContext(value);
        String key = AnnotationSupport.getKey(value);
        if (context == null || key == null) {
            throw new IOException("Context and key must be non-null");
        }
        return this.deleteWithVersion(version, context, key);
    }
}

