/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.dsl;

import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.dsl.ConsumerInfo;
import java.util.concurrent.ThreadFactory;

class EventProcessorInfo
implements ConsumerInfo {
    private final EventProcessor eventprocessor;
    private final SequenceBarrier barrier;
    private boolean endOfChain = true;

    EventProcessorInfo(EventProcessor eventprocessor, SequenceBarrier barrier) {
        this.eventprocessor = eventprocessor;
        this.barrier = barrier;
    }

    public EventProcessor getEventProcessor() {
        return this.eventprocessor;
    }

    @Override
    public Sequence[] getSequences() {
        return new Sequence[]{this.eventprocessor.getSequence()};
    }

    @Override
    public SequenceBarrier getBarrier() {
        return this.barrier;
    }

    @Override
    public boolean isEndOfChain() {
        return this.endOfChain;
    }

    @Override
    public void start(ThreadFactory threadFactory) {
        Thread thread = threadFactory.newThread(this.eventprocessor);
        if (null == thread) {
            throw new RuntimeException("Failed to create thread to run: " + this.eventprocessor);
        }
        thread.start();
    }

    @Override
    public void halt() {
        this.eventprocessor.halt();
    }

    @Override
    public void markAsUsedInBarrier() {
        this.endOfChain = false;
    }

    @Override
    public boolean isRunning() {
        return this.eventprocessor.isRunning();
    }
}

