/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.client.authentication.AttributePrincipal;
import org.apereo.cas.client.authentication.AttributePrincipalImpl;
import org.apereo.cas.client.validation.Assertion;
import org.apereo.cas.client.validation.AssertionImpl;
import org.apereo.cas.client.validation.TicketValidator;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.TicketValidationResult;

public class CASOAuth20TicketValidator
implements TicketValidator {
    private final org.apereo.cas.validation.TicketValidator validator;
    private final AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy;

    public Assertion validate(String ticket, String service) {
        TicketValidationResult validationResult = (TicketValidationResult)FunctionUtils.doUnchecked(() -> this.validator.validate(ticket, service));
        org.apereo.cas.validation.Assertion assertion = validationResult.getAssertion();
        HashMap<String, Boolean> principalAttributes = new HashMap<String, Boolean>(validationResult.getPrincipal().getAttributes());
        principalAttributes.put("org.apereo.cas.oauth.property.stateless", validationResult.getAssertion().isStateless());
        principalAttributes.putAll(assertion.getContext());
        Map originalAttributes = Optional.ofNullable(assertion.getOriginalAuthentication()).map(Authentication::getPrincipal).map(Principal::getAttributes).orElseGet(HashMap::new);
        Map finalAttributes = CoreAuthenticationUtils.mergeAttributes((Map)originalAttributes, principalAttributes);
        AttributePrincipalImpl attrPrincipal = new AttributePrincipalImpl(validationResult.getPrincipal().getId(), finalAttributes);
        RegisteredService registeredService = validationResult.getRegisteredService();
        Map authenticationAttributes = this.authenticationAttributeReleasePolicy.getAuthenticationAttributesForRelease(assertion.getPrimaryAuthentication(), assertion, new HashMap(), registeredService);
        return new AssertionImpl((AttributePrincipal)attrPrincipal, authenticationAttributes, assertion.getContext());
    }

    @Generated
    public CASOAuth20TicketValidator(org.apereo.cas.validation.TicketValidator validator, AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy) {
        this.validator = validator;
        this.authenticationAttributeReleasePolicy = authenticationAttributeReleasePolicy;
    }
}

