/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.idtoken;

import lombok.Generated;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.idtoken.IdTokenGenerationContext;
import org.apereo.cas.ticket.idtoken.IdTokenGeneratorService;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public abstract class BaseIdTokenGeneratorService<T extends OAuth20ConfigurationContext>
implements IdTokenGeneratorService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseIdTokenGeneratorService.class);
    private final ObjectProvider<T> configurationContextProvider;

    protected T getConfigurationContext() {
        return (T)((OAuth20ConfigurationContext)this.configurationContextProvider.getObject());
    }

    protected String encodeAndFinalizeToken(JwtClaims claims, IdTokenGenerationContext context) throws Throwable {
        LOGGER.debug("Received claims for the ID token [{}] as [{}]", (Object)context.getAccessToken(), (Object)claims);
        String idTokenResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().encode(context.getRegisteredService(), claims);
        context.getAccessToken().setIdToken(idTokenResult);
        if (context.getResponseType() != OAuth20ResponseTypes.ID_TOKEN && context.getAccessToken().getExpiresIn() > 0L) {
            LOGGER.debug("Updating access token [{}] in ticket registry with ID token [{}]", (Object)context.getAccessToken().getId(), (Object)idTokenResult);
            ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().updateTicket((Ticket)context.getAccessToken());
        }
        return idTokenResult;
    }

    @Generated
    protected BaseIdTokenGeneratorService(ObjectProvider<T> configurationContextProvider) {
        this.configurationContextProvider = configurationContextProvider;
    }

    @Generated
    public ObjectProvider<T> getConfigurationContextProvider() {
        return this.configurationContextProvider;
    }
}

