/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.jexl.JexlContextBuilder;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class DefaultDerAttrHandler
implements DerAttrHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(DerAttrHandler.class);
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final JexlTools jexlTools;

    public DefaultDerAttrHandler(AnyUtilsFactory anyUtilsFactory, JexlTools jexlTools) {
        this.anyUtilsFactory = anyUtilsFactory;
        this.jexlTools = jexlTools;
    }

    protected Map<String, String> getValues(Attributable attributable, Collection<? extends DerSchema> schemas) {
        HashMap<String, String> result = new HashMap<String, String>(schemas.size());
        schemas.forEach(schema -> {
            JexlContext jexlContext = new JexlContextBuilder().plainAttrs((Collection)attributable.getPlainAttrs()).fields((Object)attributable).build();
            result.put(schema.getKey(), this.jexlTools.evaluateExpression(schema.getExpression(), jexlContext).toString());
        });
        return result;
    }

    public Map<String, String> getValues(Realm realm) {
        return this.getValues((Attributable)realm, realm.getAnyTypeClasses().stream().flatMap(atc -> atc.getDerSchemas().stream()).collect(Collectors.toSet()));
    }

    public String getValue(Realm realm, DerSchema schema) {
        if (realm.getAnyTypeClasses().stream().flatMap(atc -> atc.getDerSchemas().stream()).anyMatch(arg_0 -> ((DerSchema)schema).equals(arg_0))) {
            LOG.debug("{} not allowed for {}", (Object)schema, (Object)realm);
            return null;
        }
        return this.getValues((Attributable)realm, Set.of(schema)).get(schema.getKey());
    }

    public Map<String, String> getValues(Any any) {
        return this.getValues((Attributable)any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).self());
    }

    public String getValue(Any any, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, DerSchema.class).selfContains((Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, (Object)any);
            return null;
        }
        return this.getValues((Attributable)any, Set.of(schema)).get(schema.getKey());
    }

    protected Map<String, String> getValues(Groupable<?, ?, ?> groupable, Membership<?> membership, Set<DerSchema> schemas) {
        HashMap<String, String> result = new HashMap<String, String>(schemas.size());
        schemas.forEach(schema -> {
            JexlContext jexlContext = new JexlContextBuilder().plainAttrs((Collection)groupable.getPlainAttrs(membership)).fields((Object)groupable).build();
            result.put(schema.getKey(), this.jexlTools.evaluateExpression(schema.getExpression(), jexlContext).toString());
        });
        return result;
    }

    public Map<String, String> getValues(Groupable<?, ?, ?> groupable, Membership<?> membership) {
        Set schemas = this.anyUtilsFactory.getInstance(groupable).dao().findAllowedSchemas(groupable, DerSchema.class).membership((Group)membership.getRightEnd());
        return this.getValues(groupable, membership, (Set<DerSchema>)schemas);
    }

    public String getValue(Groupable<?, ?, ?> groupable, Membership<?> membership, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(groupable).dao().findAllowedSchemas(groupable, DerSchema.class).membership((Group)membership.getRightEnd()).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, groupable);
            return null;
        }
        return this.getValues(groupable, membership, Set.of(schema)).get(schema.getKey());
    }

    protected Map<String, String> getValues(Relatable<?, ?> relatable, Relationship<?, ?> relationship, Set<DerSchema> schemas) {
        HashMap<String, String> result = new HashMap<String, String>(schemas.size());
        schemas.forEach(schema -> {
            JexlContext jexlContext = new JexlContextBuilder().plainAttrs((Collection)relatable.getPlainAttrs(relationship)).fields((Object)relatable).build();
            result.put(schema.getKey(), this.jexlTools.evaluateExpression(schema.getExpression(), jexlContext).toString());
        });
        return result;
    }

    public Map<String, String> getValues(Relatable<?, ?> relatable, Relationship<?, ?> relationship) {
        Set schemas = this.anyUtilsFactory.getInstance(relatable).dao().findAllowedSchemas(relatable, DerSchema.class).relationshipType(relationship.getType());
        return this.getValues(relatable, relationship, (Set<DerSchema>)schemas);
    }

    public String getValue(Relatable<?, ?> relatable, Relationship<?, ?> relationship, DerSchema schema) {
        if (!this.anyUtilsFactory.getInstance(relatable).dao().findAllowedSchemas(relatable, DerSchema.class).relationshipTypesContains(relationship.getType(), (Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, relatable);
            return null;
        }
        return this.getValues(relatable, relationship, Set.of(schema)).get(schema.getKey());
    }
}

