/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.EntitlementsHolder;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.data.AnyTypeDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyTypeDataBinderImpl
implements AnyTypeDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AnyTypeDataBinder.class);
    protected final SecurityProperties securityProperties;
    protected final EncryptorManager encryptorManager;
    protected final AnyTypeDAO anyTypeDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final EntityFactory entityFactory;

    public AnyTypeDataBinderImpl(SecurityProperties securityProperties, EncryptorManager encryptorManager, AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, AccessTokenDAO accessTokenDAO, EntityFactory entityFactory) {
        this.securityProperties = securityProperties;
        this.encryptorManager = encryptorManager;
        this.anyTypeDAO = anyTypeDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.entityFactory = entityFactory;
    }

    public AnyType create(AnyTypeTO anyTypeTO) {
        AnyType anyType = (AnyType)this.entityFactory.newEntity(AnyType.class);
        this.update(anyType, anyTypeTO);
        Set added = EntitlementsHolder.getInstance().addFor(anyType.getKey());
        if (!this.securityProperties.getAdminUser().equals(AuthContextUtils.getUsername())) {
            AccessToken accessToken = (AccessToken)this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("AccessToken for " + AuthContextUtils.getUsername()));
            try {
                HashSet authorities = new HashSet((Collection)POJOHelper.deserialize((String)this.encryptorManager.getInstance().decode(accessToken.getAuthorities(), CipherAlgorithm.AES), (TypeReference)new TypeReference<Set<SyncopeGrantedAuthority>>(this){}));
                added.forEach(e -> authorities.add(new SyncopeGrantedAuthority(e, "/")));
                accessToken.setAuthorities(this.encryptorManager.getInstance().encode(POJOHelper.serialize(authorities), CipherAlgorithm.AES));
                this.accessTokenDAO.save((Entity)accessToken);
            }
            catch (Exception e2) {
                LOG.error("Could not fetch or store authorities", (Throwable)e2);
            }
        }
        return anyType;
    }

    public void update(AnyType anyType, AnyTypeTO anyTypeTO) {
        if (anyType.getKey() == null) {
            anyType.setKey(anyTypeTO.getKey());
        }
        if (anyType.getKind() == null) {
            anyType.setKind(anyTypeTO.getKind());
        }
        if (anyType.getKind() != anyTypeTO.getKind()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(AnyTypeKind.class.getSimpleName() + " cannot be changed");
            throw sce;
        }
        anyTypeTO.getClasses().forEach(anyTypeClassName -> this.anyTypeClassDAO.findById(anyTypeClassName).ifPresentOrElse(arg_0 -> ((AnyType)anyType).add(arg_0), () -> LOG.debug("Invalid {} {}, ignoring...", (Object)AnyTypeClass.class.getSimpleName(), anyTypeClassName)));
        anyType.getClasses().removeIf(c -> c == null || !anyTypeTO.getClasses().contains(c.getKey()));
    }

    public AnyTypeTO delete(AnyType anyType) {
        AnyTypeTO deleted = this.getAnyTypeTO(anyType);
        this.anyTypeDAO.deleteById(anyType.getKey());
        Set removed = EntitlementsHolder.getInstance().removeFor(deleted.getKey());
        if (!this.securityProperties.getAdminUser().equals(AuthContextUtils.getUsername())) {
            AccessToken accessToken = (AccessToken)this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername()).orElseThrow(() -> new NotFoundException("AccessToken for " + AuthContextUtils.getUsername()));
            try {
                HashSet authorities = new HashSet((Collection)POJOHelper.deserialize((String)this.encryptorManager.getInstance().decode(accessToken.getAuthorities(), CipherAlgorithm.AES), (TypeReference)new TypeReference<Set<SyncopeGrantedAuthority>>(this){}));
                authorities.removeAll(authorities.stream().filter(authority -> removed.contains(authority.getAuthority())).toList());
                accessToken.setAuthorities(this.encryptorManager.getInstance().encode(POJOHelper.serialize(authorities), CipherAlgorithm.AES));
                this.accessTokenDAO.save((Entity)accessToken);
            }
            catch (Exception e) {
                LOG.error("Could not fetch or store authorities", (Throwable)e);
            }
        }
        return deleted;
    }

    public AnyTypeTO getAnyTypeTO(AnyType anyType) {
        AnyTypeTO anyTypeTO = new AnyTypeTO();
        anyTypeTO.setKey(anyType.getKey());
        anyTypeTO.setKind(anyType.getKind());
        anyTypeTO.getClasses().addAll(anyType.getClasses().stream().map(Entity::getKey).toList());
        return anyTypeTO;
    }
}

