/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relatable;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.GroupTypeExtension;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.provisioning.java.data.AnyDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class GroupDataBinderImpl
extends AnyDataBinder
implements GroupDataBinder {
    protected final SearchCondVisitor searchCondVisitor;

    public GroupDataBinderImpl(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, SearchCondVisitor searchCondVisitor, PlainAttrValidationManager validator, JexlTools jexlTools) {
        super(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator, jexlTools);
        this.searchCondVisitor = searchCondVisitor;
    }

    public void create(Group group, GroupCR groupCR) {
        GroupTO anyTO = new GroupTO();
        EntityTOUtils.toAnyTO((AnyCR)groupCR, (AnyTO)anyTO);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (groupCR.getName() == null) {
            LOG.error("No name specified for this group");
            invalidGroups.getElements().add("No name specified for this group");
        } else {
            group.setName(groupCR.getName());
        }
        Realm realm = this.realmSearchDAO.findByFullPath(groupCR.getRealm()).orElse(null);
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + groupCR.getRealm());
            scce.addException(noRealm);
        }
        group.setRealm(realm);
        this.fill((AnyTO)anyTO, (Relatable<?, ?>)group, (AnyCR)groupCR, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        groupCR.getTypeExtensions().forEach(typeExtTO -> this.anyTypeDAO.findById(typeExtTO.getAnyType()).ifPresentOrElse(anyType -> {
            GroupTypeExtension typeExt = (GroupTypeExtension)this.entityFactory.newEntity(GroupTypeExtension.class);
            typeExt.setAnyType(anyType);
            typeExt.setGroup(group);
            group.add(typeExt);
            typeExtTO.getAuxClasses().forEach(name -> this.anyTypeClassDAO.findById(name).ifPresentOrElse(arg_0 -> ((GroupTypeExtension)typeExt).add(arg_0), () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), name)));
            if (typeExt.getAuxClasses().isEmpty()) {
                group.getTypeExtensions().remove(typeExt);
                typeExt.setGroup(null);
            }
        }, () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType())));
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource<String> update(Group toBeUpdated, GroupUR groupUR) {
        Group group = (Group)this.groupDAO.save((Entity)toBeUpdated);
        GroupTO anyTO = AnyOperations.patch((GroupTO)this.getGroupTO(group, true), (GroupUR)groupUR);
        PropagationByResource propByRes = new PropagationByResource();
        Map<String, ConnObject> beforeOnResources = this.onResources((Any)group, this.groupDAO.findAllResourceKeys(group.getKey()), null, Set.of());
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        this.setRealm((Any)group, (AnyUR)groupUR);
        if (groupUR.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)groupUR.getName().getValue()))) {
            group.setName((String)groupUR.getName().getValue());
        }
        this.fill((AnyTO)anyTO, (Relatable<?, ?>)group, (AnyUR)groupUR, (PropagationByResource<String>)propByRes, this.anyUtilsFactory.getInstance(AnyTypeKind.GROUP), scce);
        group = (Group)this.groupDAO.save((Entity)group);
        for (TypeExtensionTO typeExtTO : groupUR.getTypeExtensions()) {
            AnyType anyType = this.anyTypeDAO.findById(typeExtTO.getAnyType()).orElse(null);
            if (anyType == null) {
                LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType());
                continue;
            }
            GroupTypeExtension typeExt2 = group.getTypeExtension(anyType).orElse(null);
            if (typeExt2 == null) {
                typeExt2 = (GroupTypeExtension)this.entityFactory.newEntity(GroupTypeExtension.class);
                typeExt2.setAnyType(anyType);
                typeExt2.setGroup(group);
                group.add(typeExt2);
            }
            for (String key : typeExtTO.getAuxClasses()) {
                AnyTypeClass anyTypeClass2 = this.anyTypeClassDAO.findById(key).orElse(null);
                if (anyTypeClass2 == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)key);
                    continue;
                }
                typeExt2.add(anyTypeClass2);
            }
            typeExt2.getAuxClasses().removeIf(anyTypeClass -> !typeExtTO.getAuxClasses().contains(anyTypeClass.getKey()));
            if (!typeExt2.getAuxClasses().isEmpty()) continue;
            group.getTypeExtensions().remove(typeExt2);
            typeExt2.setGroup(null);
        }
        group.getTypeExtensions().removeIf(typeExt -> groupUR.getTypeExtension(typeExt.getAnyType().getKey()).isEmpty());
        if (scce.hasExceptions()) {
            throw scce;
        }
        group = (Group)this.groupDAO.save((Entity)group);
        propByRes.merge(this.propByRes(beforeOnResources, this.onResources((Any)group, this.groupDAO.findAllResourceKeys(group.getKey()), null, Set.of())));
        return propByRes;
    }

    public TypeExtensionTO getTypeExtensionTO(GroupTypeExtension typeExt) {
        TypeExtensionTO typeExtTO = new TypeExtensionTO();
        typeExtTO.setAnyType(typeExt.getAnyType().getKey());
        typeExtTO.getAuxClasses().addAll(typeExt.getAuxClasses().stream().map(Entity::getKey).toList());
        return typeExtTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(Group group, boolean details) {
        GroupTO groupTO = new GroupTO();
        groupTO.setKey(group.getKey());
        groupTO.setName(group.getName());
        groupTO.setStatus(group.getStatus());
        groupTO.setCreator(group.getCreator());
        groupTO.setCreationDate(group.getCreationDate());
        groupTO.setCreationContext(group.getCreationContext());
        groupTO.setLastModifier(group.getLastModifier());
        groupTO.setLastChangeDate(group.getLastChangeDate());
        groupTO.setLastChangeContext(group.getLastChangeContext());
        GroupDataBinderImpl.fillTO((Any)group, (AnyTO)groupTO, this.derAttrHandler.getValues((Any)group), group.getResources());
        groupTO.setUserMembershipCount(this.groupDAO.countUMembers(group.getKey()));
        groupTO.setAnyObjectMembershipCount(this.groupDAO.countAMembers(group.getKey()));
        group.getTypeExtensions().forEach(typeExt -> groupTO.getTypeExtensions().add(this.getTypeExtensionTO((GroupTypeExtension)typeExt)));
        if (details) {
            groupTO.getRelationships().addAll(group.getRelationships().stream().map(relationship -> GroupDataBinderImpl.getRelationshipTO(group.getPlainAttrs((Relationship)relationship), this.derAttrHandler.getValues((Relatable)group, (Relationship)relationship), relationship.getType().getKey(), RelationshipTO.End.LEFT, relationship.getRightEnd())).toList());
        }
        return groupTO;
    }

    @Transactional(readOnly=true)
    public GroupTO getGroupTO(String key) {
        return this.getGroupTO((Group)this.groupDAO.authFind(key), true);
    }

    protected static void populateTransitiveResources(Group group, Groupable<?, ?, ?> any, Map<String, PropagationByResource<String>> result) {
        PropagationByResource propByRes = new PropagationByResource();
        group.getResources().forEach(resource -> {
            if (!any.getResources().contains(resource) && any.getMemberships().stream().filter(m -> !((Group)m.getRightEnd()).equals((Object)group)).noneMatch(m -> ((Group)m.getRightEnd()).getResources().contains(resource))) {
                propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()));
            }
            if (!propByRes.isEmpty()) {
                result.put(any.getKey(), propByRes);
            }
        });
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource<String>> findAnyObjectsWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource<String>> result = new HashMap<String, PropagationByResource<String>>();
        this.groupDAO.findAMemberships(group).forEach(membership -> GroupDataBinderImpl.populateTransitiveResources(group, (Groupable)membership.getLeftEnd(), result));
        return result;
    }

    @Transactional(readOnly=true)
    public Map<String, PropagationByResource<String>> findUsersWithTransitiveResources(String groupKey) {
        Group group = (Group)this.groupDAO.authFind(groupKey);
        HashMap<String, PropagationByResource<String>> result = new HashMap<String, PropagationByResource<String>>();
        this.groupDAO.findUMemberships(group, Pageable.unpaged()).forEach(membership -> GroupDataBinderImpl.populateTransitiveResources(group, (Groupable)membership.getLeftEnd(), result));
        return result;
    }
}

