/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Optional;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.RelationshipTypeExtension;
import org.apache.syncope.core.provisioning.api.data.RelationshipTypeDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipTypeDataBinderImpl
implements RelationshipTypeDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(RelationshipTypeDataBinder.class);
    protected final AnyTypeDAO anyTypeDAO;
    protected final AnyTypeClassDAO anyTypeClassDAO;
    protected final EntityFactory entityFactory;

    public RelationshipTypeDataBinderImpl(AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, EntityFactory entityFactory) {
        this.anyTypeDAO = anyTypeDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.entityFactory = entityFactory;
    }

    public RelationshipType create(RelationshipTypeTO relationshipTypeTO) {
        RelationshipType relationshipType = (RelationshipType)this.entityFactory.newEntity(RelationshipType.class);
        relationshipType.setLeftEndAnyType((AnyType)Optional.ofNullable(relationshipTypeTO.getLeftEndAnyType()).flatMap(arg_0 -> ((AnyTypeDAO)this.anyTypeDAO).findById(arg_0)).orElseThrow(() -> new NotFoundException("AnyType " + relationshipTypeTO.getLeftEndAnyType())));
        relationshipType.setRightEndAnyType((AnyType)Optional.ofNullable(relationshipTypeTO.getRightEndAnyType()).flatMap(arg_0 -> ((AnyTypeDAO)this.anyTypeDAO).findById(arg_0)).orElseThrow(() -> new NotFoundException("AnyType " + relationshipTypeTO.getRightEndAnyType())));
        this.update(relationshipType, relationshipTypeTO);
        return relationshipType;
    }

    public void update(RelationshipType relationshipType, RelationshipTypeTO relationshipTypeTO) {
        if (relationshipType.getKey() == null) {
            relationshipType.setKey(relationshipTypeTO.getKey());
        }
        relationshipType.setDescription(relationshipTypeTO.getDescription());
        relationshipTypeTO.getTypeExtensions().forEach(typeExtTO -> this.anyTypeDAO.findById(typeExtTO.getAnyType()).ifPresentOrElse(anyType -> {
            RelationshipTypeExtension typeExt = relationshipType.getTypeExtension(anyType).orElse(null);
            if (typeExt == null) {
                typeExt = (RelationshipTypeExtension)this.entityFactory.newEntity(RelationshipTypeExtension.class);
                typeExt.setAnyType(anyType);
                typeExt.setRelationshipType(relationshipType);
                relationshipType.add(typeExt);
            }
            for (String key : typeExtTO.getAuxClasses()) {
                AnyTypeClass anyTypeClass2 = this.anyTypeClassDAO.findById(key).orElse(null);
                if (anyTypeClass2 == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)key);
                    continue;
                }
                typeExt.add(anyTypeClass2);
            }
            typeExt.getAuxClasses().removeIf(anyTypeClass -> !typeExtTO.getAuxClasses().contains(anyTypeClass.getKey()));
            if (typeExt.getAuxClasses().isEmpty()) {
                relationshipType.getTypeExtensions().remove(typeExt);
                typeExt.setRelationshipType(null);
            }
        }, () -> LOG.warn("Ignoring invalid {}: {}", (Object)AnyType.class.getSimpleName(), (Object)typeExtTO.getAnyType())));
        relationshipType.getTypeExtensions().removeIf(typeExt -> relationshipTypeTO.getTypeExtension(typeExt.getAnyType().getKey()).isEmpty());
    }

    public TypeExtensionTO getTypeExtensionTO(RelationshipTypeExtension typeExt) {
        TypeExtensionTO typeExtTO = new TypeExtensionTO();
        typeExtTO.setAnyType(typeExt.getAnyType().getKey());
        typeExtTO.getAuxClasses().addAll(typeExt.getAuxClasses().stream().map(Entity::getKey).toList());
        return typeExtTO;
    }

    public RelationshipTypeTO getRelationshipTypeTO(RelationshipType relationshipType) {
        RelationshipTypeTO relationshipTypeTO = new RelationshipTypeTO();
        relationshipTypeTO.setKey(relationshipType.getKey());
        relationshipTypeTO.setDescription(relationshipType.getDescription());
        relationshipTypeTO.setLeftEndAnyType(relationshipType.getLeftEndAnyType().getKey());
        relationshipTypeTO.setRightEndAnyType(relationshipType.getRightEndAnyType().getKey());
        relationshipType.getTypeExtensions().forEach(typeExt -> relationshipTypeTO.getTypeExtensions().add(this.getTypeExtensionTO((RelationshipTypeExtension)typeExt)));
        return relationshipTypeTO;
    }
}

