/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.rest.PasswordManagementRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.password.PasswordManagementConf;
import org.apache.syncope.common.lib.to.PasswordManagementTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.springframework.util.ClassUtils;

public class PasswordManagementWizardBuilder
extends BaseAjaxWizardBuilder<PasswordManagementTO> {
    private static final long serialVersionUID = -6355254150868269721L;
    protected final LoadableDetachableModel<List<String>> passwordManagementConfs = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return SyncopeWebApplication.get().getLookup().getClasses(PasswordManagementConf.class).stream().map(Class::getName).sorted().collect(Collectors.toList());
        }
    };
    protected final PasswordManagementRestClient passwordManagementRestClient;
    protected final Model<Class<? extends PasswordManagementConf>> passwordManagementConfClass = Model.of();

    public PasswordManagementWizardBuilder(PasswordManagementTO defaultItem, PasswordManagementRestClient passwordManagementRestClient, PageReference pageRef) {
        super((Serializable)defaultItem, pageRef);
        this.passwordManagementRestClient = passwordManagementRestClient;
    }

    protected Serializable onApplyInternal(PasswordManagementTO modelObject) {
        if (this.mode == AjaxWizard.Mode.CREATE) {
            this.passwordManagementRestClient.create(modelObject);
        } else {
            this.passwordManagementRestClient.update(modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(PasswordManagementTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject, this.passwordManagementConfs, this.passwordManagementConfClass));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        return wizardModel;
    }

    protected static class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        Profile(final PasswordManagementTO passwordManagement, LoadableDetachableModel<List<String>> passwordManagementConfs, final Model<Class<? extends PasswordManagementConf>> passwordManagementConfClass) {
            boolean isNew;
            boolean bl = isNew = passwordManagement.getConf() == null;
            if (!isNew) {
                passwordManagementConfClass.setObject((Serializable)passwordManagement.getConf().getClass());
            }
            AjaxTextFieldPanel key = new AjaxTextFieldPanel("key", "key", (IModel)new PropertyModel((Object)passwordManagement, "key"));
            key.addRequiredLabel();
            key.setEnabled(isNew);
            this.add(new Component[]{key});
            AjaxTextFieldPanel description = new AjaxTextFieldPanel("description", this.getString("description"), (IModel)new PropertyModel((Object)passwordManagement, "description"));
            this.add(new Component[]{description});
            AjaxCheckBoxPanel isEnabled = new AjaxCheckBoxPanel("enabled", "enabled", (IModel)new PropertyModel((Object)passwordManagement, "enabled"));
            this.add(new Component[]{isEnabled});
            final AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("conf", this.getString("type"), (IModel)(isNew ? Model.of() : Model.of((Serializable)((Object)passwordManagement.getConf().getClass().getName()))));
            conf.setChoices((List)passwordManagementConfs.getObject());
            conf.addRequiredLabel();
            conf.setNullValid(false);
            conf.setEnabled(isNew);
            conf.add(new Behavior[]{new AjaxEventBehavior(this, "change"){
                private static final long serialVersionUID = -7133385027739964990L;
                final /* synthetic */ Profile this$0;
                {
                    this.this$0 = this$0;
                    super(event);
                }

                protected void onEvent(AjaxRequestTarget target) {
                    try {
                        Class clazz = ClassUtils.resolveClassName((String)((String)((Object)conf.getModelObject())), (ClassLoader)ClassUtils.getDefaultClassLoader());
                        passwordManagement.setConf((PasswordManagementConf)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        passwordManagementConfClass.setObject((Serializable)clazz);
                    }
                    catch (Exception e) {
                        LOG.error("Cannot instantiate {}", (Object)conf.getModelObject(), (Object)e);
                    }
                }
            }});
            this.add(new Component[]{conf});
        }
    }

    protected class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        Configuration(PasswordManagementTO passwordManagement) {
            this.add(new Component[]{new BeanPanel("bean", (IModel)new PropertyModel((Object)passwordManagement, "conf"), PasswordManagementWizardBuilder.this.pageRef, new String[]{"ldap", "keystore", "serviceProviderMetadata"}).setRenderBodyOnly(true)});
        }
    }
}

