/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.persistence.PostLoad;
import jakarta.persistence.Transient;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.RegisteredServiceAttributeReleaseActivationCriteria;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class GroovyRegisteredServiceAttributeReleaseActivationCriteria
implements RegisteredServiceAttributeReleaseActivationCriteria {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyRegisteredServiceAttributeReleaseActivationCriteria.class);
    private static final long serialVersionUID = 1942510462696845607L;
    private int order;
    @ExpressionLanguageCapable
    private String groovyScript;
    @JsonIgnore
    @Transient
    @org.springframework.data.annotation.Transient
    private transient ExecutableCompiledScript executableScript;

    public boolean shouldActivate(RegisteredServiceAttributeReleasePolicyContext context) {
        this.initializeWatchableScriptIfNeeded();
        return (Boolean)FunctionUtils.doIfNotNull((Object)this.executableScript, () -> this.getGroovyScriptResult(context), () -> false).get();
    }

    protected Boolean getGroovyScriptResult(RegisteredServiceAttributeReleasePolicyContext context) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            Map args = CollectionUtils.wrap((String)"context", (Object)context, (String)"logger", (Object)LOGGER);
            this.executableScript.setBinding(args);
            return (Boolean)this.executableScript.execute(args.values().toArray(), Boolean.class);
        }, e -> Boolean.FALSE).get();
    }

    @PostLoad
    private void initializeWatchableScriptIfNeeded() {
        String script;
        ExecutableCompiledScriptFactory scriptFactoryInstance = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        if (scriptFactoryInstance.isExternalScript(this.groovyScript)) {
            script = SpringExpressionLanguageValueResolver.getInstance().resolve((String)scriptFactoryInstance.getExternalScript(this.groovyScript).orElseThrow());
            AbstractResource resource = (AbstractResource)FunctionUtils.doUnchecked(() -> ResourceUtils.getRawResourceFrom((String)script));
            this.executableScript = scriptFactoryInstance.fromResource((Resource)resource);
        }
        if (scriptFactoryInstance.isInlineScript(this.groovyScript) && CasRuntimeHintsRegistrar.notInNativeImage()) {
            script = (String)scriptFactoryInstance.getInlineScript(this.groovyScript).orElseThrow();
            this.executableScript = scriptFactoryInstance.fromScript(script);
        }
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public ExecutableCompiledScript getExecutableScript() {
        return this.executableScript;
    }

    @Generated
    public GroovyRegisteredServiceAttributeReleaseActivationCriteria setOrder(int order) {
        this.order = order;
        return this;
    }

    @Generated
    public GroovyRegisteredServiceAttributeReleaseActivationCriteria setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
        return this;
    }

    @Generated
    public GroovyRegisteredServiceAttributeReleaseActivationCriteria setExecutableScript(ExecutableCompiledScript executableScript) {
        this.executableScript = executableScript;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroovyRegisteredServiceAttributeReleaseActivationCriteria)) {
            return false;
        }
        GroovyRegisteredServiceAttributeReleaseActivationCriteria other = (GroovyRegisteredServiceAttributeReleaseActivationCriteria)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        String this$groovyScript = this.groovyScript;
        String other$groovyScript = other.groovyScript;
        return !(this$groovyScript == null ? other$groovyScript != null : !this$groovyScript.equals(other$groovyScript));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroovyRegisteredServiceAttributeReleaseActivationCriteria;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.order;
        String $groovyScript = this.groovyScript;
        result = result * 59 + ($groovyScript == null ? 43 : $groovyScript.hashCode());
        return result;
    }

    @Generated
    public GroovyRegisteredServiceAttributeReleaseActivationCriteria() {
    }
}

