/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.issuer;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.util.RegexUtils;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcDefaultIssuerService
implements OidcIssuerService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultIssuerService.class);
    protected final OidcProperties properties;
    protected final TenantExtractor tenantExtractor;

    @Override
    public String determineIssuer(Optional<OidcRegisteredService> registeredService) {
        String issuer = registeredService.filter(svc -> StringUtils.isNotBlank((CharSequence)svc.getIdTokenIssuer())).map(OidcRegisteredService::getIdTokenIssuer).orElseGet(() -> this.properties.getCore().getIssuer());
        LOGGER.trace("Determined issuer as [{}] for [{}]", (Object)issuer, (Object)registeredService.map(RegisteredServiceDefinition::getName).orElse("CAS"));
        return Strings.CI.removeEnd(issuer, (CharSequence)"/");
    }

    @Override
    public boolean validateIssuer(WebContext webContext, List<String> endpoints, OidcRegisteredService registeredService) {
        String requestUrl = webContext.getRequestURL();
        String definedIssuer = this.determineIssuer(Optional.ofNullable(registeredService));
        String definedIssuerWithSlash = Strings.CI.appendIfMissing(definedIssuer, (CharSequence)"/", new CharSequence[0]);
        boolean foundMatch = endpoints.stream().anyMatch(endpoint -> {
            String issuerFromRequestUrl = Strings.CI.removeEnd(Strings.CI.remove(requestUrl, "/" + endpoint), (CharSequence)"/");
            return definedIssuer.equalsIgnoreCase(issuerFromRequestUrl) || issuerFromRequestUrl.startsWith(definedIssuerWithSlash) || definedIssuer.startsWith(issuerFromRequestUrl) || RegexUtils.find((String)this.properties.getCore().getAcceptedIssuersPattern(), (String)issuerFromRequestUrl);
        });
        if (!foundMatch) {
            LOGGER.debug("Cannot accept issuer [{}] at [{}] for any of the endpoints [{}]", new Object[]{webContext.getRequestURL(), endpoints, definedIssuer});
        }
        return foundMatch;
    }

    @Generated
    public OidcDefaultIssuerService(OidcProperties properties, TenantExtractor tenantExtractor) {
        this.properties = properties;
        this.tenantExtractor = tenantExtractor;
    }
}

