/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.services.DefaultRegisteredServiceUserInterfaceInfo;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OidcRegisteredServiceUIAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRegisteredServiceUIAction.class);
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionStrategy serviceSelectionStrategy;

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        WebApplicationService serviceCtx = WebUtils.getService((RequestContext)requestContext);
        if (serviceCtx != null) {
            Service service = this.serviceSelectionStrategy.resolveServiceFrom((Service)serviceCtx);
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            LOGGER.debug("Found registered service [{}] from the context", (Object)registeredService.getServiceId());
            if (registeredService instanceof OidcRegisteredService) {
                OidcRegisteredService oauthService = (OidcRegisteredService)registeredService;
                WebUtils.putServiceUserInterfaceMetadata((RequestContext)requestContext, (Serializable)new DefaultRegisteredServiceUserInterfaceInfo((WebBasedRegisteredService)oauthService));
            }
        }
        return this.success();
    }

    @Generated
    public OidcRegisteredServiceUIAction(ServicesManager servicesManager, AuthenticationServiceSelectionStrategy serviceSelectionStrategy) {
        this.servicesManager = servicesManager;
        this.serviceSelectionStrategy = serviceSelectionStrategy;
    }
}

