/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import lombok.Generated;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProviderAbsentException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.authentication.CasWebflowExceptionHandler;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class OidcUnmetAuthenticationRequirementWebflowExceptionHandler
implements CasWebflowExceptionHandler<AuthenticationException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcUnmetAuthenticationRequirementWebflowExceptionHandler.class);
    private final OidcConfigurationContext context;
    private int order;

    public Event handle(AuthenticationException exception, RequestContext requestContext) {
        return (Event)FunctionUtils.doUnchecked(() -> {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            WebApplicationService service = this.context.getArgumentExtractor().extractService(request);
            String redirectUri = CollectionUtils.firstElement(service.getAttributes().get("redirect_uri")).orElseThrow().toString();
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByRedirectUri((ServicesManager)this.context.getServicesManager(), (String)redirectUri);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
            URI url = new URIBuilder(redirectUri).addParameter("error", "unmet_authentication_requirements").build();
            requestContext.getRequestScope().put("url", (Object)url);
            LOGGER.debug("Redirecting to [{}]", (Object)url);
            return EVENT_FACTORY.event((Object)this, "redirect");
        });
    }

    public boolean supports(Exception exception, RequestContext requestContext) {
        AuthenticationException e;
        return exception instanceof AuthenticationException && (e = (AuthenticationException)exception).getHandlerErrors().containsKey(MultifactorAuthenticationProviderAbsentException.class.getSimpleName());
    }

    @Generated
    public OidcConfigurationContext getContext() {
        return this.context;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public OidcUnmetAuthenticationRequirementWebflowExceptionHandler(OidcConfigurationContext context) {
        this.context = context;
    }
}

