/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.spi.support;

import java.util.HashMap;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.springframework.webflow.execution.Event;

public class NullableReturnValueAuditResourceResolver
implements AuditResourceResolver {
    protected Function<String[], String[]> resourcePostProcessor = Function.identity();
    private final AuditResourceResolver delegate;
    private AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.DEFAULT;

    public String[] resolveFrom(JoinPoint joinPoint, Object returnValue) {
        if (returnValue == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (returnValue instanceof Event) {
            Event event = (Event)returnValue;
            String sourceName = event.getSource().getClass().getSimpleName();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("event", event.getId());
            values.put("timestamp", DateTimeUtils.localDateTimeOf((long)event.getTimestamp()).toString());
            values.put("source", sourceName);
            if (event.getAttributes() != null && !event.getAttributes().isEmpty()) {
                HashMap<String, Object> attributes = new HashMap<String, Object>(event.getAttributes().asMap());
                attributes.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(CentralAuthenticationService.NAMESPACE));
                attributes.forEach((key, value) -> {
                    if (value != null) {
                        values.put((String)key, value.toString());
                    }
                });
            }
            if (this.auditFormat == AuditTrailManager.AuditFormats.JSON) {
                return this.resourcePostProcessor.apply(new String[]{AuditTrailManager.toJson(values)});
            }
            return this.resourcePostProcessor.apply(new String[]{values.toString()});
        }
        return this.resourcePostProcessor.apply(this.delegate.resolveFrom(joinPoint, returnValue));
    }

    public String[] resolveFrom(JoinPoint joinPoint, Exception e) {
        return this.resourcePostProcessor.apply(this.delegate.resolveFrom(joinPoint, e));
    }

    @Generated
    public void setResourcePostProcessor(Function<String[], String[]> resourcePostProcessor) {
        this.resourcePostProcessor = resourcePostProcessor;
    }

    @Generated
    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditFormat = auditFormat;
    }

    @Generated
    public NullableReturnValueAuditResourceResolver(AuditResourceResolver delegate) {
        this.delegate = delegate;
    }
}

