/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.support;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.AttributeIndex;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.persistence.support.FilteredObjectStore;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.common.WrappedResultSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class PartialIndex<A, O, I extends AttributeIndex<A, O>>
implements AttributeIndex<A, O> {
    static final int INDEX_RETRIEVAL_COST_DELTA = -5;
    protected final Query<O> filterQuery;
    protected final Attribute<O, A> attribute;
    protected volatile I backingIndex;

    protected PartialIndex(Attribute<O, A> attribute, Query<O> filterQuery) {
        this.attribute = attribute;
        this.filterQuery = filterQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I backingIndex() {
        if (this.backingIndex == null) {
            PartialIndex partialIndex = this;
            synchronized (partialIndex) {
                if (this.backingIndex == null) {
                    this.backingIndex = this.createBackingIndex();
                }
            }
        }
        return this.backingIndex;
    }

    @Override
    public Attribute<O, A> getAttribute() {
        return this.backingIndex().getAttribute();
    }

    public Query<O> getFilterQuery() {
        return this.filterQuery;
    }

    public AttributeIndex<A, O> getBackingIndex() {
        return this.backingIndex;
    }

    @Override
    public boolean supportsQuery(Query<O> query, QueryOptions queryOptions) {
        Query rootQuery = (Query)queryOptions.get("ROOT_QUERY");
        return PartialIndex.supportsQueryInternal(this.backingIndex(), this.filterQuery, rootQuery, query, queryOptions);
    }

    static <A, O, I extends AttributeIndex<A, O>> boolean supportsQueryInternal(I backingIndex, Query<O> filterQuery, Query<O> rootQuery, Query<O> branchQuery, QueryOptions queryOptions) {
        if (!backingIndex.supportsQuery(branchQuery, queryOptions)) {
            return false;
        }
        if (filterQuery.equals(rootQuery)) {
            return true;
        }
        if (!(rootQuery instanceof And)) {
            return false;
        }
        And rootAndQuery = (And)rootQuery;
        if (rootAndQuery.getChildQueries().contains(filterQuery)) {
            return true;
        }
        if (!(filterQuery instanceof And)) {
            return false;
        }
        And filterAndQuery = (And)filterQuery;
        return rootAndQuery.getChildQueries().containsAll(filterAndQuery.getChildQueries());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartialIndex)) {
            return false;
        }
        PartialIndex that = (PartialIndex)o;
        if (!this.filterQuery.equals(that.filterQuery)) {
            return false;
        }
        return this.backingIndex().equals(that.backingIndex());
    }

    public int hashCode() {
        int result = this.filterQuery.hashCode();
        result = 31 * result + this.backingIndex().hashCode();
        return result;
    }

    @Override
    public boolean isMutable() {
        return this.backingIndex().isMutable();
    }

    @Override
    public boolean isQuantized() {
        return this.backingIndex().isQuantized();
    }

    @Override
    public ResultSet<O> retrieve(Query<O> query, QueryOptions queryOptions) {
        return new WrappedResultSet<O>(this.backingIndex().retrieve(query, queryOptions)){

            @Override
            public int getRetrievalCost() {
                return super.getRetrievalCost() + -5;
            }
        };
    }

    @Override
    public Index<O> getEffectiveIndex() {
        return this;
    }

    @Override
    public void init(ObjectStore<O> objectStore, QueryOptions queryOptions) {
        this.backingIndex().init(new FilteredObjectStore<O>(objectStore, this.filterQuery), queryOptions);
    }

    @Override
    public void destroy(QueryOptions queryOptions) {
        this.backingIndex().destroy(queryOptions);
    }

    @Override
    public boolean addAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        Collection<O> matchingSubset = this.filter(objectSet, queryOptions);
        return this.backingIndex().addAll(ObjectSet.fromCollection(matchingSubset), queryOptions);
    }

    @Override
    public boolean removeAll(ObjectSet<O> objectSet, QueryOptions queryOptions) {
        Collection<O> matchingSubset = this.filter(objectSet, queryOptions);
        return this.backingIndex().removeAll(ObjectSet.fromCollection(matchingSubset), queryOptions);
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.backingIndex().clear(queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<O> filter(ObjectSet<O> objects, QueryOptions queryOptions) {
        try (Iterator objectsIterator = objects.iterator();){
            HashSet matchingSubset = new HashSet();
            while (objectsIterator.hasNext()) {
                Object candidate = objectsIterator.next();
                if (!this.filterQuery.matches(candidate, queryOptions)) continue;
                matchingSubset.add(candidate);
            }
            HashSet hashSet = matchingSubset;
            return hashSet;
        }
    }

    protected abstract I createBackingIndex();
}

