/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.configuration.model.support.syncope.BaseSyncopeSearchProperties;
import org.apereo.cas.configuration.model.support.syncope.SyncopePrincipalProvisioningProperties;
import org.apereo.cas.syncope.SyncopeUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class SyncopePrincipalProvisioner
implements PrincipalProvisioner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopePrincipalProvisioner.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final SyncopePrincipalProvisioningProperties properties;

    public boolean provision(Principal principal, Credential credential) {
        return (Boolean)FunctionUtils.doUnchecked(() -> {
            LOGGER.info("Searching Syncope to find [{}]", (Object)principal.getId());
            List<Map<String, List<Object>>> userList = SyncopeUtils.syncopeUserSearch((BaseSyncopeSearchProperties)this.properties, principal.getId());
            if (userList.isEmpty()) {
                return this.createUserResource(principal, credential);
            }
            return userList.stream().allMatch(Unchecked.predicate(__ -> this.updateUserResource(principal)));
        });
    }

    protected boolean updateUserResource(Principal principal) throws Exception {
        return Splitter.on((String)",").splitToList((CharSequence)this.properties.getDomain()).stream().allMatch(Unchecked.predicate(domain -> {
            boolean bl;
            HttpResponse response = null;
            try {
                String syncopeRestUrl = Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getUrl()), (CharSequence)("/rest/users/" + principal.getId()), new CharSequence[0]);
                Map headers = CollectionUtils.wrap((String)"X-Syncope-Domain", (Object)domain, (String)"Accept", (Object)"application/json", (String)"Content-Type", (Object)"application/json");
                headers.putAll(this.properties.getHeaders());
                String entity = MAPPER.writeValueAsString(SyncopeUtils.convertToUserUpdateEntity(principal, this.getSyncopeRealm(principal)));
                HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.PATCH).url(syncopeRestUrl).basicAuthUsername(this.properties.getBasicAuthUsername()).basicAuthPassword(this.properties.getBasicAuthPassword()).headers(headers).entity(entity).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
                LOGGER.debug("Received http response status as [{}]", (Object)response.getReasonPhrase());
                String result = EntityUtils.toString((HttpEntity)((HttpEntityContainer)response).getEntity());
                LOGGER.debug("Received response payload as [{}]", (Object)result);
                bl = HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful();
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return bl;
        }));
    }

    protected String getSyncopeRealm(Principal principal) {
        return CollectionUtils.firstElement(principal.getAttributes().get("realm")).map(Object::toString).orElseGet(() -> ((SyncopePrincipalProvisioningProperties)this.properties).getRealm());
    }

    protected boolean createUserResource(Principal principal, Credential credential) throws Exception {
        return Splitter.on((String)",").splitToList((CharSequence)this.properties.getDomain()).stream().allMatch(Unchecked.predicate(domain -> {
            boolean bl;
            HttpResponse response = null;
            try {
                String syncopeRestUrl = Strings.CI.appendIfMissing(SpringExpressionLanguageValueResolver.getInstance().resolve(this.properties.getUrl()), (CharSequence)"/rest/users", new CharSequence[0]);
                Map headers = CollectionUtils.wrap((String)"X-Syncope-Domain", (Object)domain, (String)"Accept", (Object)"application/json", (String)"Content-Type", (Object)"application/json");
                headers.putAll(this.properties.getHeaders());
                String entity = MAPPER.writeValueAsString(SyncopeUtils.convertToUserCreateEntity(principal, this.getSyncopeRealm(principal)));
                HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(syncopeRestUrl).basicAuthUsername(this.properties.getBasicAuthUsername()).basicAuthPassword(this.properties.getBasicAuthPassword()).headers(headers).entity(entity).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpExecutionRequest)exec));
                LOGGER.debug("Received http response status as [{}]", (Object)response.getReasonPhrase());
                String result = EntityUtils.toString((HttpEntity)((HttpEntityContainer)response).getEntity());
                LOGGER.debug("Received response payload as [{}]", (Object)result);
                bl = HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful();
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return bl;
        }));
    }

    @Generated
    public SyncopePrincipalProvisioner(SyncopePrincipalProvisioningProperties properties) {
        this.properties = properties;
    }
}

