/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.handler.TenantAuthenticationHandlerBuilder;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAuthenticationProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.syncope.SyncopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class TenantSyncopeAuthenticationHandlerBuilder
implements TenantAuthenticationHandlerBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantSyncopeAuthenticationHandlerBuilder.class);
    protected final PasswordPolicyContext passwordPolicyConfiguration;
    protected final PrincipalFactory principalFactory;
    protected final ConfigurableApplicationContext applicationContext;
    protected final ServicesManager servicesManager;

    public List<? extends AuthenticationHandler> buildInternal(TenantDefinition tenantDefinition, ConfigurationPropertiesBindingContext<CasConfigurationProperties> bindingContext) {
        if (bindingContext.isBound() && bindingContext.containsBindingFor(SyncopeAuthenticationProperties.class)) {
            CasConfigurationProperties casProperties = (CasConfigurationProperties)bindingContext.value();
            SyncopeAuthenticationProperties syncope = casProperties.getAuthn().getSyncope();
            List<? extends AuthenticationHandler> handlers = SyncopeUtils.newAuthenticationHandlers(syncope, this.applicationContext, this.principalFactory, this.servicesManager, this.passwordPolicyConfiguration);
            handlers.forEach(AuthenticationHandler::markDisposable);
            return handlers;
        }
        return List.of();
    }

    @Generated
    public TenantSyncopeAuthenticationHandlerBuilder(PasswordPolicyContext passwordPolicyConfiguration, PrincipalFactory principalFactory, ConfigurableApplicationContext applicationContext, ServicesManager servicesManager) {
        this.passwordPolicyConfiguration = passwordPolicyConfiguration;
        this.principalFactory = principalFactory;
        this.applicationContext = applicationContext;
        this.servicesManager = servicesManager;
    }
}

